/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckConfig;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckResult;
import com.thalesgroup.hudson.plugins.cppcheck.util.CppcheckBuildHealthEvaluator;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import java.io.Serializable;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckBuildAction
implements Action,
Serializable,
StaplerProxy,
HealthReportingAction {
    public static final String URL_NAME = "cppcheckResult";
    private AbstractBuild<?, ?> build;
    private CppcheckResult result;
    private CppcheckConfig cppcheckConfig;

    public CppcheckBuildAction(AbstractBuild<?, ?> build, CppcheckResult result, CppcheckConfig cppcheckConfig) {
        this.build = build;
        this.result = result;
        this.cppcheckConfig = cppcheckConfig;
    }

    public String getIconFileName() {
        return "/plugin/cppcheck/icons/cppcheck-24.png";
    }

    public String getDisplayName() {
        return "Cppcheck Result";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public CppcheckResult getResult() {
        return this.result;
    }

    AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public Object getTarget() {
        return this.result;
    }

    public HealthReport getBuildHealth() {
        return new CppcheckBuildHealthEvaluator().evaluatBuildHealth(this.cppcheckConfig, this.getNumberErrors(this.cppcheckConfig, false));
    }

    public int getNumberErrors(CppcheckConfig cppecheckConfig, boolean checkNewError) {
        int nbErrors = 0;
        int nbPreviousError = 0;
        CppcheckResult previousResult = this.result.getPreviousResult();
        if (cppecheckConfig.isSeverityPossibleError()) {
            nbErrors = this.getResult().getReport().getPossibleErrorSeverities().size();
            if (previousResult != null) {
                nbPreviousError = previousResult.getReport().getPossibleErrorSeverities().size();
            }
        }
        if (cppecheckConfig.isSeverityStyle()) {
            nbErrors += this.getResult().getReport().getStyleSeverities().size();
            if (previousResult != null) {
                nbPreviousError += previousResult.getReport().getStyleSeverities().size();
            }
        }
        if (cppecheckConfig.isSeverityPossibleStyle()) {
            nbErrors += this.getResult().getReport().getPossibleStyleSeverities().size();
            if (previousResult != null) {
                nbPreviousError += previousResult.getReport().getPossibleStyleSeverities().size();
            }
        }
        if (cppecheckConfig.isSeverityError()) {
            nbErrors += this.getResult().getReport().getErrorSeverities().size();
            if (previousResult != null) {
                nbPreviousError += previousResult.getReport().getErrorSeverities().size();
            }
        }
        if (checkNewError) {
            if (previousResult != null) {
                return nbErrors - nbPreviousError;
            }
            return 0;
        }
        return nbErrors;
    }
}

