/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckBuildAction;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckConfig;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckParserResult;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckProjectAction;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckResult;
import com.thalesgroup.hudson.plugins.cppcheck.util.CppcheckBuildResultEvaluator;
import com.thalesgroup.hudson.plugins.cppcheck.util.Messages;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckPublisher
extends Publisher {
    private CppcheckConfig cppcheckConfig;
    public static final CppcheckDescriptor DESCRIPTOR = new CppcheckDescriptor();

    public CppcheckDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CppcheckProjectAction(project);
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (this.canContinue(build.getResult())) {
            Messages.log(listener, "Starting the cppcheck analysis.");
            FilePath[] moduleRoots = build.getProject().getModuleRoots();
            boolean multipleModuleRoots = moduleRoots != null && moduleRoots.length > 1;
            FilePath moduleRoot = multipleModuleRoots ? build.getProject().getWorkspace() : build.getProject().getModuleRoot();
            CppcheckParserResult parser = new CppcheckParserResult(listener, this.cppcheckConfig.getCppcheckReportPattern());
            CppcheckReport cppcheckReport = null;
            try {
                cppcheckReport = (CppcheckReport)moduleRoot.act((FilePath.FileCallable)parser);
            }
            catch (Exception e) {
                Messages.log(listener, "Error on cppcheck analysis: " + e);
                build.setResult(Result.FAILURE);
                return false;
            }
            if (cppcheckReport == null) {
                build.setResult(Result.FAILURE);
                return false;
            }
            CppcheckResult result = new CppcheckResult(cppcheckReport, build);
            CppcheckBuildAction buildAction = new CppcheckBuildAction(build, result, this.cppcheckConfig);
            build.addAction((Action)buildAction);
            Result buildResult = new CppcheckBuildResultEvaluator().evaluateBuildResult(listener, buildAction.getNumberErrors(this.cppcheckConfig, false), buildAction.getNumberErrors(this.cppcheckConfig, true), this.cppcheckConfig);
            if (buildResult != Result.SUCCESS) {
                build.setResult(buildResult);
            }
            Messages.log(listener, "End of the cppcheck analysis.");
        }
        return true;
    }

    public CppcheckConfig getCppcheckConfig() {
        return this.cppcheckConfig;
    }

    public void setCppcheckConfig(CppcheckConfig cppcheckConfig) {
        this.cppcheckConfig = cppcheckConfig;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CppcheckDescriptor
    extends BuildStepDescriptor<Publisher> {
        public CppcheckDescriptor() {
            super(CppcheckPublisher.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType) || MatrixProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "Publish Cppcheck results";
        }

        public final String getHelpFile() {
            return this.getPluginRoot() + "help.html";
        }

        public String getPluginRoot() {
            return "/plugin/cppcheck/";
        }

        public CppcheckConfig getConfig() {
            return new CppcheckConfig();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            CppcheckPublisher pub = new CppcheckPublisher();
            CppcheckConfig cppcheckConfig = (CppcheckConfig)req.bindJSON(CppcheckConfig.class, formData);
            pub.setCppcheckConfig(cppcheckConfig);
            return pub;
        }
    }
}

