/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck.util;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckConfig;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckMetricUtil;
import hudson.model.HealthReport;

public class CppcheckBuildHealthEvaluator {
    public HealthReport evaluatBuildHealth(CppcheckConfig cppcheckConfig, int nbErrorForSeverity) {
        if (cppcheckConfig == null) {
            return null;
        }
        if (this.isHealthyReportEnabled(cppcheckConfig)) {
            int counter = nbErrorForSeverity;
            int percentage = counter < CppcheckMetricUtil.convert(cppcheckConfig.getHealthy()) ? 100 : (counter > CppcheckMetricUtil.convert(cppcheckConfig.getUnHealthy()) ? 0 : 100 - (counter - CppcheckMetricUtil.convert(cppcheckConfig.getHealthy())) * 100 / (CppcheckMetricUtil.convert(cppcheckConfig.getUnHealthy()) - CppcheckMetricUtil.convert(cppcheckConfig.getHealthy())));
            return new HealthReport(percentage, "Build stability for checked severities severity.");
        }
        return null;
    }

    private boolean isHealthyReportEnabled(CppcheckConfig cppcheckconfig) {
        if (CppcheckMetricUtil.isValid(cppcheckconfig.getHealthy()) && CppcheckMetricUtil.isValid(cppcheckconfig.getUnHealthy())) {
            int healthyNumber = CppcheckMetricUtil.convert(cppcheckconfig.getHealthy());
            int unHealthyNumber = CppcheckMetricUtil.convert(cppcheckconfig.getUnHealthy());
            return unHealthyNumber > healthyNumber;
        }
        return false;
    }
}

