/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck.util;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckConfig;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckMetricUtil;
import com.thalesgroup.hudson.plugins.cppcheck.util.Messages;
import hudson.model.BuildListener;
import hudson.model.Result;

public class CppcheckBuildResultEvaluator {
    private boolean isErrorCountExceeded(int errorCount, String errorThreshold) {
        if (errorCount > 0 && CppcheckMetricUtil.isValid(errorThreshold)) {
            return errorCount > CppcheckMetricUtil.convert(errorThreshold);
        }
        return false;
    }

    public Result evaluateBuildResult(BuildListener listener, int errorsCount, int newErrorsCount, CppcheckConfig cppcheckConfig) {
        if (this.isErrorCountExceeded(errorsCount, cppcheckConfig.getFailureThreshold())) {
            Messages.log(listener, "Setting build status to FAILURE since total number of errors (" + CppcheckMetricUtil.getMessageSelectedSeverties(cppcheckConfig) + ") exceeds the threshold value ;" + cppcheckConfig.getFailureThreshold() + "'.");
            return Result.FAILURE;
        }
        if (this.isErrorCountExceeded(newErrorsCount, cppcheckConfig.getNewFailureThreshold())) {
            Messages.log(listener, "Setting build status to FAILURE since total number of new errors (" + CppcheckMetricUtil.getMessageSelectedSeverties(cppcheckConfig) + ") exceeds the threshold value '" + cppcheckConfig.getNewFailureThreshold() + "'.");
            return Result.FAILURE;
        }
        if (this.isErrorCountExceeded(errorsCount, cppcheckConfig.getThreshold())) {
            Messages.log(listener, "Setting build status to UNSTABLE since total number of errors (" + CppcheckMetricUtil.getMessageSelectedSeverties(cppcheckConfig) + ") exceeds the threshold value '" + cppcheckConfig.getThreshold() + "'.");
            return Result.UNSTABLE;
        }
        if (this.isErrorCountExceeded(newErrorsCount, cppcheckConfig.getNewThreshold())) {
            Messages.log(listener, "Setting build status to UNSTABLE since total number of new errors (" + CppcheckMetricUtil.getMessageSelectedSeverties(cppcheckConfig) + ") exceeds the threshold value '" + cppcheckConfig.getNewThreshold() + "'.");
            return Result.UNSTABLE;
        }
        Messages.log(listener, "Not changing build status, since no threshold has been exceeded");
        return Result.SUCCESS;
    }
}

