/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.parser.CppcheckParser;
import com.thalesgroup.hudson.plugins.cppcheck.util.CppcheckLogger;
import hudson.FilePath;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CppcheckParserResult
implements FilePath.FileCallable<CppcheckReport> {
    private static final long serialVersionUID = 1L;
    private final BuildListener listener;
    private final String cppcheckReportPattern;
    public static final String DELAULT_REPORT_MAVEN = "**/cppcheck-result.xml";

    public CppcheckParserResult(BuildListener listener, String cppcheckReportPattern) {
        if (cppcheckReportPattern == null) {
            cppcheckReportPattern = "**/cppcheck-result.xml";
        }
        if (cppcheckReportPattern.trim().length() == 0) {
            cppcheckReportPattern = "**/cppcheck-result.xml";
        }
        this.listener = listener;
        this.cppcheckReportPattern = cppcheckReportPattern;
    }

    public CppcheckReport invoke(File basedir, VirtualChannel channel) throws IOException {
        CppcheckReport cppcheckReportResult = new CppcheckReport();
        try {
            String[] cppcheckReportFiles = this.findCppcheckReports(basedir);
            if (cppcheckReportFiles.length == 0) {
                String msg = "No cppcheck test report file(s) were found with the pattern '" + this.cppcheckReportPattern + "' relative to '" + basedir + "'." + "  Did you enter a pattern relative to the correct directory?" + "  Did you generate the XML report(s) for Cppcheck?";
                throw new IllegalArgumentException(msg);
            }
            CppcheckLogger.log((BuildListener)this.listener, (String)("Processing " + cppcheckReportFiles.length + " files with the pattern '" + this.cppcheckReportPattern + "'."));
            for (String cppchecReportkFileName : cppcheckReportFiles) {
                CppcheckReport cppcheckReport = new CppcheckParser().parse(new File(basedir, cppchecReportkFileName));
                CppcheckParserResult.mergeReport((CppcheckReport)cppcheckReportResult, (CppcheckReport)cppcheckReport);
            }
        }
        catch (Exception e) {
            CppcheckLogger.log((BuildListener)this.listener, (String)("Parsing has been canceled. " + e.getMessage()));
            return null;
        }
        return cppcheckReportResult;
    }

    private static void mergeReport(CppcheckReport cppcheckReportResult, CppcheckReport cppcheckReport) {
        cppcheckReportResult.getPossibleErrorSeverities().addAll(cppcheckReport.getPossibleErrorSeverities());
        cppcheckReportResult.getPossibleStyleSeverities().addAll(cppcheckReport.getPossibleStyleSeverities());
        cppcheckReportResult.getErrorSeverities().addAll(cppcheckReport.getErrorSeverities());
        cppcheckReportResult.getEverySeverities().addAll(cppcheckReport.getEverySeverities());
        cppcheckReportResult.getNoCategorySeverities().addAll(cppcheckReport.getNoCategorySeverities());
        cppcheckReportResult.getStyleSeverities().addAll(cppcheckReport.getStyleSeverities());
    }

    private String[] findCppcheckReports(File parentPath) {
        FileSet fs = Util.createFileSet((File)parentPath, (String)this.cppcheckReportPattern);
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] cppcheckFiles = ds.getIncludedFiles();
        return cppcheckFiles;
    }

    public String getCppcheckReportPattern() {
        return this.cppcheckReportPattern;
    }
}

