/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckResult;
import com.thalesgroup.hudson.plugins.cppcheck.config.CppcheckConfig;
import com.thalesgroup.hudson.plugins.cppcheck.config.CppcheckConfigGraph;
import com.thalesgroup.hudson.plugins.cppcheck.graph.CppcheckGraph;
import com.thalesgroup.hudson.plugins.cppcheck.util.AbstractCppcheckBuildAction;
import com.thalesgroup.hudson.plugins.cppcheck.util.CppcheckBuildHealthEvaluator;
import hudson.model.AbstractBuild;
import hudson.model.HealthReport;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.IOException;
import java.util.Calendar;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckBuildAction
extends AbstractCppcheckBuildAction {
    public static final String URL_NAME = "cppcheckResult";
    private CppcheckResult result;
    private CppcheckConfig cppcheckConfig;

    public CppcheckBuildAction(AbstractBuild<?, ?> owner, CppcheckResult result, CppcheckConfig cppcheckConfig) {
        super(owner);
        this.result = result;
        this.cppcheckConfig = cppcheckConfig;
    }

    public String getIconFileName() {
        return "/plugin/cppcheck/icons/cppcheck-24.png";
    }

    public String getDisplayName() {
        return "Cppcheck Result";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public CppcheckResult getResult() {
        return this.result;
    }

    AbstractBuild<?, ?> getBuild() {
        return this.owner;
    }

    public Object getTarget() {
        return this.result;
    }

    public HealthReport getBuildHealth() {
        try {
            return new CppcheckBuildHealthEvaluator().evaluatBuildHealth(this.cppcheckConfig, this.result.getNumberErrorsAccordingConfiguration(this.cppcheckConfig, false));
        }
        catch (IOException ioe) {
            return new HealthReport();
        }
    }

    private DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> getDataSetBuilder() {
        DataSetBuilder dsb = new DataSetBuilder();
        for (CppcheckBuildAction a = this; a != null; a = (CppcheckBuildAction)a.getPreviousResult()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.owner);
            CppcheckReport report = a.getResult().getReport();
            CppcheckConfigGraph configGraph = this.cppcheckConfig.getConfigGraph();
            if (configGraph.isDisplaySeverityStyle()) {
                dsb.add((Number)report.getNumberSeverityStyle(), (Comparable)((Object)"Severity 'style'"), (Comparable)label);
            }
            if (configGraph.isDisplaySeverityPossibleStyle()) {
                dsb.add((Number)report.getNumberSeverityPossibleStyle(), (Comparable)((Object)"Severity 'possibe style'"), (Comparable)label);
            }
            if (configGraph.isDisplaySeverityPossibleError()) {
                dsb.add((Number)report.getNumberSeverityPossibleError(), (Comparable)((Object)"Severity 'possible error'"), (Comparable)label);
            }
            if (configGraph.isDisplaySeverityError()) {
                dsb.add((Number)report.getNumberSeverityError(), (Comparable)((Object)"Severity 'error'"), (Comparable)label);
            }
            if (!configGraph.isDiplayAllError()) continue;
            dsb.add((Number)report.getNumberTotal(), (Comparable)((Object)"All errors"), (Comparable)label);
        }
        return dsb;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Calendar timestamp = this.getBuild().getTimestamp();
        if (req.checkIfModified(timestamp, rsp)) {
            return;
        }
        CppcheckGraph g = new CppcheckGraph(this.getOwner(), this.getDataSetBuilder().build(), "Number of error", this.cppcheckConfig.getConfigGraph().getXSize(), this.cppcheckConfig.getConfigGraph().getYSize());
        g.doPng(req, rsp);
    }
}

