/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck.model;

import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckFile;
import hudson.model.AbstractBuild;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckWorkspaceFile {
    public static final String WORKSPACE_FILES = "workspace-files";
    private String fileName;
    private CppcheckFile cppcheckFile;
    private boolean sourceIgnored;

    public CppcheckWorkspaceFile(File file) {
        if (file != null) {
            this.fileName = file.getAbsolutePath().replace('\\', '/');
        }
    }

    public CppcheckWorkspaceFile() {
    }

    public CppcheckFile getCppcheckFile() {
        return this.cppcheckFile;
    }

    public void setCppcheckFile(CppcheckFile cppcheckFile) {
        this.cppcheckFile = cppcheckFile;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getTempName() {
        return Integer.toHexString(this.getFileName().hashCode()) + ".tmp";
    }

    public final String getFileName() {
        return this.fileName;
    }

    public String getTempName(AbstractBuild<?, ?> owner) {
        if (this.fileName != null) {
            return owner.getRootDir().getAbsolutePath() + "/" + WORKSPACE_FILES + "/" + Integer.toHexString(this.fileName.hashCode()) + ".tmp";
        }
        return "";
    }

    public boolean isSourceIgnored() {
        return this.sourceIgnored;
    }

    public void setSourceIgnored(boolean sourceIgnored) {
        this.sourceIgnored = sourceIgnored;
    }
}

