/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck.model;

import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckFile;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckWorkspaceFile;
import com.thalesgroup.hudson.plugins.cppcheck.util.CppcheckLogger;
import hudson.FilePath;
import hudson.model.BuildListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckSourceContainer {
    private Map<Integer, CppcheckWorkspaceFile> internalMap = new HashMap();

    public CppcheckSourceContainer(BuildListener listener, FilePath basedir, List<CppcheckFile> files) throws IOException, InterruptedException {
        for (CppcheckFile cppcheckFile : files) {
            CppcheckWorkspaceFile cppcheckWorkspaceFile = new CppcheckWorkspaceFile();
            FilePath sourceFilePath = new FilePath(basedir, cppcheckFile.getFileName());
            if (!sourceFilePath.exists()) {
                CppcheckLogger.log((BuildListener)listener, (String)("[WARNING] - The source file '" + sourceFilePath.toURI() + "' doesn't exist on the slave. The ability to display its source code has been removed."));
                cppcheckWorkspaceFile.setSourceIgnored(true);
                cppcheckWorkspaceFile.setFileName(null);
            } else if (sourceFilePath.isDirectory()) {
                cppcheckWorkspaceFile.setFileName(sourceFilePath.getRemote());
                cppcheckWorkspaceFile.setSourceIgnored(true);
            } else {
                cppcheckWorkspaceFile.setFileName(sourceFilePath.getRemote());
                cppcheckWorkspaceFile.setSourceIgnored(false);
            }
            cppcheckWorkspaceFile.setCppcheckFile(cppcheckFile);
            this.internalMap.put(cppcheckFile.getKey(), cppcheckWorkspaceFile);
        }
    }

    public Map<Integer, CppcheckWorkspaceFile> getInternalMap() {
        return this.internalMap;
    }
}

