/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppncss;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.plugins.cppncss.CppNCSSGhostwriter;
import hudson.plugins.cppncss.CppNCSSHealthTarget;
import hudson.plugins.cppncss.CppNCSSProjectIndividualReport;
import hudson.plugins.cppncss.CppNCSSPublisher;
import hudson.plugins.helpers.AbstractPublisherImpl;
import hudson.plugins.helpers.Ghostwriter;
import hudson.tasks.Publisher;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppNCSSPublisher
extends AbstractPublisherImpl {
    private String reportFilenamePattern;
    private Integer functionCcnViolationThreshold = 10;
    private Integer functionNcssViolationThreshold = 100;
    private CppNCSSHealthTarget[] targets;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl(null);

    @DataBoundConstructor
    public CppNCSSPublisher(String reportFilenamePattern, Integer functionCcnViolationThreshold, Integer functionNcssViolationThreshold, CppNCSSHealthTarget[] targets) {
        reportFilenamePattern.getClass();
        this.reportFilenamePattern = reportFilenamePattern;
        this.functionCcnViolationThreshold = functionCcnViolationThreshold;
        this.functionNcssViolationThreshold = functionNcssViolationThreshold;
        this.targets = targets == null ? new CppNCSSHealthTarget[]{} : targets;
    }

    public String getReportFilenamePattern() {
        return this.reportFilenamePattern;
    }

    public Integer getFunctionCcnViolationThreshold() {
        return this.functionCcnViolationThreshold;
    }

    public Integer getFunctionNcssViolationThreshold() {
        return this.functionNcssViolationThreshold;
    }

    public CppNCSSHealthTarget[] getTargets() {
        return this.targets;
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CppNCSSProjectIndividualReport(project, this.functionCcnViolationThreshold, this.functionNcssViolationThreshold);
    }

    protected Ghostwriter newGhostwriter() {
        return new CppNCSSGhostwriter(this.reportFilenamePattern, this.functionCcnViolationThreshold, this.functionNcssViolationThreshold, this.targets);
    }
}

