/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.helpers;

import hudson.model.AbstractBuild;
import hudson.plugins.cppncss.AbstractBuildReport;
import hudson.plugins.helpers.GraphHelper;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.DefaultCategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class GraphHelper {
    private GraphHelper() {
    }

    public static boolean isGraphUnsupported() {
        return ChartUtil.awtProblem;
    }

    public static void redirectWhenGraphUnsupported(StaplerResponse rsp, StaplerRequest req) throws IOException {
        rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
    }

    public static JFreeChart buildChart(AbstractBuild<?, ?> build, Integer functionCcnViolationThreshold, Integer functionNcssViolationThreshold) {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"Total Files", (CategoryDataset)GraphHelper.buildDataset(build, (DataCollector)new /* Unavailable Anonymous Inner Class!! */), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        DefaultCategoryItemRenderer firstRender = new DefaultCategoryItemRenderer();
        plot.setRenderer((CategoryItemRenderer)firstRender);
        int index = 1;
        GraphHelper.build_category(build, (JFreeChart)chart, (int)index, (Color)Color.BLUE, (String)"Non Commenting Source Statements", (CategoryDatasetBuilder)new /* Unavailable Anonymous Inner Class!! */);
        GraphHelper.build_category(build, (JFreeChart)chart, (int)(++index), (Color)Color.GREEN, (String)"McCabe's Cyclomatic Number", (CategoryDatasetBuilder)new /* Unavailable Anonymous Inner Class!! */);
        GraphHelper.build_category(build, (JFreeChart)chart, (int)(++index), (Color)Color.ORANGE, (String)"Total Functions", (CategoryDatasetBuilder)new /* Unavailable Anonymous Inner Class!! */);
        GraphHelper.build_category(build, (JFreeChart)chart, (int)(++index), (Color)Color.CYAN, (String)"CCN Violated Functions", (CategoryDatasetBuilder)new /* Unavailable Anonymous Inner Class!! */);
        GraphHelper.build_category(build, (JFreeChart)chart, (int)(++index), (Color)Color.MAGENTA, (String)"NCSS Violated Functions", (CategoryDatasetBuilder)new /* Unavailable Anonymous Inner Class!! */);
        return chart;
    }

    private static void build_category(AbstractBuild<?, ?> build, JFreeChart chart, int index, Color color, String title, CategoryDatasetBuilder datasetBuilder) {
        NumberAxis axis = new NumberAxis(title);
        axis.setLabelPaint((Paint)color);
        axis.setAxisLinePaint((Paint)color);
        axis.setTickLabelPaint((Paint)color);
        CategoryPlot categoryPlot = chart.getCategoryPlot();
        categoryPlot.setRangeAxis(index, (ValueAxis)axis);
        categoryPlot.setDataset(index, datasetBuilder.buildData());
        categoryPlot.mapDatasetToRangeAxis(index, index);
        categoryPlot.mapDatasetToDomainAxis(index, 0);
        DefaultCategoryItemRenderer rendu = new DefaultCategoryItemRenderer();
        rendu.setPaint((Paint)color);
        categoryPlot.setRenderer(index, (CategoryItemRenderer)rendu);
    }

    private static CategoryDataset buildDataset(AbstractBuild<?, ?> build, DataCollector collector) {
        DataSetBuilder builder = new DataSetBuilder();
        for (AbstractBuild lastBuild = build; lastBuild != null; lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(lastBuild);
            AbstractBuildReport action = (AbstractBuildReport)lastBuild.getAction(AbstractBuildReport.class);
            if (action == null) continue;
            builder.add((Number)collector.getCollectedNumber(action), (Comparable)((Object)collector.getTitle()), (Comparable)label);
        }
        return builder.build();
    }

    static /* synthetic */ CategoryDataset access$000(AbstractBuild x0, DataCollector x1) {
        return GraphHelper.buildDataset((AbstractBuild)x0, (DataCollector)x1);
    }
}

