/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cpptest;

import hudson.plugins.cpptest.CpptestResult;
import hudson.plugins.cpptest.Messages;

public final class ResultSummary {
    public static String createSummary(CpptestResult result) {
        StringBuilder summary = new StringBuilder();
        int bugs = result.getNumberOfAnnotations();
        summary.append("Code standard: ");
        if (bugs > 0) {
            summary.append("<a href=\"CpptestResult\">");
        }
        if (bugs == 1) {
            summary.append(Messages.Cpptest_ResultAction_OneWarning());
        } else {
            summary.append(Messages.Cpptest_ResultAction_MultipleWarnings(bugs));
        }
        if (bugs > 0) {
            summary.append("</a>");
        }
        summary.append(" ");
        if (result.getNumberOfModules() == 1) {
            summary.append(Messages.Cpptest_ResultAction_OneFile());
        } else {
            summary.append(Messages.Cpptest_ResultAction_MultipleFiles(result.getNumberOfModules()));
        }
        return summary.toString();
    }

    public static String createDeltaMessage(CpptestResult result) {
        StringBuilder summary = new StringBuilder();
        if (result.getNumberOfNewWarnings() > 0) {
            summary.append("<li><a href=\"CpptestResult/new\">");
            if (result.getNumberOfNewWarnings() == 1) {
                summary.append(Messages.Cpptest_ResultAction_OneNewWarning());
            } else {
                summary.append(Messages.Cpptest_ResultAction_MultipleNewWarnings(result.getNumberOfNewWarnings()));
            }
            summary.append("</a></li>");
        }
        if (result.getNumberOfFixedWarnings() > 0) {
            summary.append("<li><a href=\"CpptestResult/fixed\">");
            if (result.getNumberOfFixedWarnings() == 1) {
                summary.append(Messages.Cpptest_ResultAction_OneFixedWarning());
            } else {
                summary.append(Messages.Cpptest_ResultAction_MultipleFixedWarnings(result.getNumberOfFixedWarnings()));
            }
            summary.append("</a></li>");
        }
        return summary.toString();
    }

    private ResultSummary() {
    }
}

