/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cpptest;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.cpptest.CpptestDescriptor;
import hudson.plugins.cpptest.CpptestProjectAction;
import hudson.plugins.cpptest.CpptestResult;
import hudson.plugins.cpptest.CpptestResultAction;
import hudson.plugins.cpptest.parser.CpptestParser;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpptestPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = 6369581633551160418L;
    private static final String DEFAULT_PATTERN = "**/Cpptest-result.xml";
    private final String pattern;

    @DataBoundConstructor
    public CpptestPublisher(String pattern, String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues) {
        super(threshold, newThreshold, failureThreshold, newFailureThreshold, healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, "Cpptest");
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CpptestProjectAction(project);
    }

    public BuildResult perform(AbstractBuild<?, ?> build, PluginLogger logger) throws InterruptedException, IOException {
        logger.log("Collecting Cpptest analysis files...");
        FilesParser parser = new FilesParser(logger, StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN), (AnnotationParser)new CpptestParser(this.getDefaultEncoding()), this.isMavenBuild(build), this.isAntBuild(build));
        ParserResult project = (ParserResult)build.getWorkspace().act((FilePath.FileCallable)parser);
        CpptestResult result = new CpptestResult(build, this.getDefaultEncoding(), project);
        build.getActions().add(new CpptestResultAction(build, (HealthDescriptor)this, result));
        return result;
    }

    public CpptestDescriptor getDescriptor() {
        return (CpptestDescriptor)super.getDescriptor();
    }
}

