/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cpptest.parser;

import hudson.plugins.analysis.core.AbstractAnnotationParser;
import hudson.plugins.analysis.util.JavaPackageDetector;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.cpptest.parser.Category;
import hudson.plugins.cpptest.parser.Cpptest;
import hudson.plugins.cpptest.parser.Location;
import hudson.plugins.cpptest.parser.RuleDesc;
import hudson.plugins.cpptest.parser.StdViol;
import hudson.plugins.cpptest.parser.Warning;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpptestParser
extends AbstractAnnotationParser {
    private static final long serialVersionUID = -8705621867291182458L;

    public CpptestParser() {
        super("");
    }

    public CpptestParser(String defaultEncoding) {
        super(defaultEncoding);
    }

    public Collection<FileAnnotation> parse(InputStream file, String moduleName) throws InvocationTargetException {
        try {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(CpptestParser.class.getClassLoader());
            String rootXPath = "ResultsSession";
            digester.addObjectCreate(rootXPath, Cpptest.class);
            digester.addSetProperties(rootXPath);
            String fileXPath = "ResultsSession/CodingStandards/StdViols/StdViol";
            digester.addObjectCreate(fileXPath, StdViol.class);
            digester.addSetProperties(fileXPath);
            digester.addSetNext(fileXPath, "addFile", StdViol.class.getName());
            String ruleXPath = "ResultsSession/CodingStandards/Rules/RulesList/Rule";
            digester.addObjectCreate(ruleXPath, RuleDesc.class);
            digester.addSetProperties(ruleXPath);
            digester.addSetNext(ruleXPath, "addRuleDesc", RuleDesc.class.getName());
            String categoryXPath = "ResultsSession/CodingStandards/Rules/CategoriesList/Category";
            digester.addObjectCreate(categoryXPath, Category.class);
            digester.addSetProperties(categoryXPath);
            digester.addSetNext(categoryXPath, "addCategory", Category.class.getName());
            String locXPath = "ResultsSession/Locations/Loc";
            digester.addObjectCreate(locXPath, Location.class);
            digester.addSetProperties(locXPath);
            digester.addSetNext(locXPath, "addLocation", Location.class.getName());
            Cpptest module = (Cpptest)digester.parse((Reader)new InputStreamReader(file, "UTF-8"));
            if (module == null) {
                throw new SAXException("Input stream is not a Cpptest file.");
            }
            return this.convert(module, moduleName);
        }
        catch (IOException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SAXException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    private Collection<FileAnnotation> convert(Cpptest collection, String moduleName) {
        ArrayList<FileAnnotation> annotations = new ArrayList<FileAnnotation>();
        for (StdViol viol : collection.getFiles()) {
            Priority priority;
            if (!this.isValidWarning(viol)) continue;
            String packageName = new JavaPackageDetector().detectPackageName(viol.getRule());
            if ("1".equalsIgnoreCase(viol.getSev())) {
                priority = Priority.HIGH;
            } else if ("2".equalsIgnoreCase(viol.getSev())) {
                priority = Priority.HIGH;
            } else if ("3".equalsIgnoreCase(viol.getSev())) {
                priority = Priority.NORMAL;
            } else if ("4".equalsIgnoreCase(viol.getSev())) {
                priority = Priority.NORMAL;
            } else {
                if (!"5".equalsIgnoreCase(viol.getSev())) continue;
                priority = Priority.LOW;
            }
            String type = viol.getRule();
            String category = viol.getCat();
            for (Category categ : collection.getCategories()) {
                if (!categ.getName().equals(category)) continue;
                category = categ.getDesc();
                break;
            }
            Warning warning = new Warning(priority, viol.getMsg(), StringUtils.capitalize((String)category), type, viol.getLn(), viol.getLn());
            warning.setFileName(viol.getLocFile());
            for (RuleDesc rule : collection.getRuleDescs()) {
                if (!rule.getId().equals(viol.getRule())) continue;
                warning.setDesc(rule.getDesc());
                break;
            }
            for (Location loc : collection.getLocations()) {
                if (!loc.getLoc().equals(viol.getLocFile())) continue;
                warning.setFileName(loc.getFsPath());
                break;
            }
            warning.setModuleName(moduleName);
            warning.setPackageName(packageName);
            try {
                warning.setContextHashCode(this.createContextHashCode(viol.getRule(), viol.getLn()));
            }
            catch (IOException exception) {
                // empty catch block
            }
            annotations.add((FileAnnotation)warning);
        }
        return annotations;
    }

    private boolean isValidWarning(StdViol viol) {
        return !viol.getRule().endsWith("package.html");
    }
}

