/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppunit;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.plugins.cppunit.CppUnitTransformer;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppUnitArchiver
implements FilePath.FileCallable<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JUNIT_REPORTS_PATH = "temporary-junit-reports";
    private CppUnitTransformer reportTransformer;
    private final BuildListener listener;
    private final String testResultsPattern;

    public CppUnitArchiver(BuildListener listener, String testResults, CppUnitTransformer reportTransformer) throws TransformerException {
        this.listener = listener;
        this.testResultsPattern = testResults;
        this.reportTransformer = reportTransformer;
    }

    public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
        boolean retValue = false;
        String[] cppunitFiles = this.findCppUnitReports(ws);
        if (cppunitFiles.length > 0) {
            File junitOutputPath = new File(ws, JUNIT_REPORTS_PATH);
            junitOutputPath.mkdirs();
            for (String cppunitFileName : cppunitFiles) {
                File fileCppunitReport = new File(ws, cppunitFileName);
                FileInputStream fileStream = new FileInputStream(fileCppunitReport);
                String fileCppunitReportName = fileCppunitReport.getName();
                try {
                    this.reportTransformer.transform(fileCppunitReportName, (InputStream)fileStream, junitOutputPath);
                }
                catch (Exception te) {
                    throw new IOException2("Could not transform the CppUnit report.", (Throwable)te);
                }
                finally {
                    fileStream.close();
                }
            }
            retValue = true;
        }
        return retValue;
    }

    private String[] findCppUnitReports(File parentPath) throws AbortException {
        FileSet fs = Util.createFileSet((File)parentPath, (String)this.testResultsPattern);
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] cppunitFiles = ds.getIncludedFiles();
        if (cppunitFiles.length == 0) {
            this.listener.fatalError("No CppUnit test report files were found. Configuration error?");
        }
        return cppunitFiles;
    }
}

