/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppunit;

import hudson.FilePath;
import hudson.plugins.cppunit.CppUnitTransformer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;

public class CppUnitTransformerImpl
implements CppUnitTransformer {
    private transient Transformer cppunitXMLTransformer;
    private static final String JUNIT_FILE_POSTFIX = ".xml";
    private static final String JUNIT_FILE_PREFIX = "TEST-";
    public static final String CPPUNIT_TO_JUNIT_XSL = "cppunit-to-junit.xsl";
    private FilePath customStylesheet;

    public CppUnitTransformerImpl() {
        this.customStylesheet = null;
    }

    public CppUnitTransformerImpl(FilePath customStylesheet) {
        this.customStylesheet = customStylesheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(String cppunitFileName, InputStream cppunitFileStream, File junitOutputPath) throws IOException, TransformerException, SAXException, ParserConfigurationException, InterruptedException, IOException {
        this.initializeProcessor();
        File junitTargetFile = new File(junitOutputPath, JUNIT_FILE_PREFIX + cppunitFileName + JUNIT_FILE_POSTFIX);
        FileOutputStream fileOutputStream = new FileOutputStream(junitTargetFile);
        try {
            this.cppunitXMLTransformer.transform(new StreamSource(cppunitFileStream), new StreamResult(fileOutputStream));
        }
        finally {
            fileOutputStream.close();
        }
    }

    private void initializeProcessor() throws TransformerFactoryConfigurationError, TransformerConfigurationException, ParserConfigurationException, InterruptedException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StreamSource streamSourceXSL = this.customStylesheet != null ? new StreamSource(new File(this.customStylesheet.toURI())) : new StreamSource(this.getClass().getResourceAsStream(CPPUNIT_TO_JUNIT_XSL));
        this.cppunitXMLTransformer = transformerFactory.newTransformer(streamSourceXSL);
    }
}

