/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppunit;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.cppunit.CppUnitArchiver;
import hudson.plugins.cppunit.CppUnitPublisher;
import hudson.plugins.cppunit.CppUnitTransformer;
import hudson.plugins.cppunit.CppUnitTransformerImpl;
import hudson.tasks.Publisher;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CppUnitPublisher
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl();
    private String testResultsPattern;
    private boolean useCustomStylesheet;
    private String customStylesheet;

    @DataBoundConstructor
    public CppUnitPublisher(String testResultsPattern, boolean useCustomStylesheet, String customStylesheet) {
        this.testResultsPattern = testResultsPattern;
        this.useCustomStylesheet = useCustomStylesheet;
        this.customStylesheet = customStylesheet;
    }

    public String getTestResultsPattern() {
        return this.testResultsPattern;
    }

    public boolean getUseCustomStylesheet() {
        return this.useCustomStylesheet;
    }

    public String getCustomStylesheet() {
        return this.customStylesheet;
    }

    public Action getProjectAction(Project project) {
        return new TestResultProjectAction((AbstractProject)project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean result = true;
        try {
            CppUnitTransformerImpl cppUnitTransformer;
            listener.getLogger().println("Recording CppUnit tests results.");
            if (this.useCustomStylesheet && this.customStylesheet != null) {
                listener.getLogger().println("Use the specified stylesheet.");
                FilePath customStylesheetFilePath = ((AbstractProject)build.getParent()).getModuleRoot().child(this.customStylesheet);
                cppUnitTransformer = new CppUnitTransformerImpl(customStylesheetFilePath);
            } else {
                listener.getLogger().println("Use the default CppUnit plugin stylesheet.");
                cppUnitTransformer = new CppUnitTransformerImpl();
            }
            CppUnitArchiver archiver = new CppUnitArchiver(listener, this.testResultsPattern, (CppUnitTransformer)cppUnitTransformer);
            result = (Boolean)build.getProject().getWorkspace().act((FilePath.FileCallable)archiver);
            if (result) {
                result = this.recordTestResult("temporary-junit-reports/TEST-*.xml", build, listener);
                build.getProject().getWorkspace().child("temporary-junit-reports").deleteRecursive();
            }
            listener.getLogger().println("End recording CppUnit tests results.");
        }
        catch (TransformerException te) {
            listener.getLogger().println("Error publishing cppunit results" + te.toString());
            throw new AbortException("Could not read the XSL XML file.");
        }
        return result;
    }

    private boolean recordTestResult(String junitFilePattern, AbstractBuild<?, ?> build, BuildListener listener) throws InterruptedException, IOException {
        TestResultAction action;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        try {
            long buildTime = build.getTimestamp().getTimeInMillis();
            TestResult existingTestResults = null;
            if (existingAction != null) {
                existingTestResults = existingAction.getResult();
            }
            TestResult result = this.getTestResult(junitFilePattern, build, existingTestResults, buildTime);
            if (existingAction == null) {
                action = new TestResultAction(build, result, listener);
            } else {
                action = existingAction;
                action.setResult(result, listener);
            }
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                throw new AbortException("None of the test reports contained any result");
            }
        }
        catch (AbortException e) {
            if (build.getResult() == Result.FAILURE) {
                return true;
            }
            listener.getLogger().println(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        if (existingAction == null) {
            build.getActions().add(action);
        }
        if (action.getResult().getFailCount() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    private TestResult getTestResult(String junitFilePattern, AbstractBuild<?, ?> build, TestResult existingTestResults, long buildTime) throws IOException, InterruptedException {
        TestResult result = (TestResult)build.getProject().getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    public Descriptor getDescriptor() {
        return DESCRIPTOR;
    }

    private static FilePath getWorkspace(AbstractProject p) {
        try {
            return p.getWorkspace();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    static /* synthetic */ FilePath access$000(AbstractProject x0) {
        return CppUnitPublisher.getWorkspace((AbstractProject)x0);
    }
}

