/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppunit;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.cppunit.CppUnitArchiver;
import hudson.plugins.cppunit.CppUnitTransformer;
import hudson.plugins.cppunit.util.Messages;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.xml.transform.TransformerException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppUnitPublisher
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final CppUnitDescriptor DESCRIPTOR = new CppUnitDescriptor();
    private String testResultsPattern;
    private boolean useCustomStylesheet;
    private String customStylesheet;
    private static final Logger LOG = Logger.getLogger(CppUnitPublisher.class.getName());

    @DataBoundConstructor
    public CppUnitPublisher(String testResultsPattern, boolean useCustomStylesheet, String customStylesheet) {
        this.testResultsPattern = testResultsPattern;
        this.useCustomStylesheet = useCustomStylesheet;
        this.customStylesheet = customStylesheet;
    }

    public String getTestResultsPattern() {
        return this.testResultsPattern;
    }

    public boolean getUseCustomStylesheet() {
        return this.useCustomStylesheet;
    }

    public String getCustomStylesheet() {
        return this.customStylesheet;
    }

    public Action getProjectAction(Project project) {
        return new TestResultProjectAction((AbstractProject)project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean result = false;
        try {
            CppUnitTransformer cppUnitTransformer;
            Messages.log(listener, "Recording CppUnit tests results.");
            if (this.useCustomStylesheet && this.customStylesheet != null) {
                Messages.log(listener, "Use the specified stylesheet.");
                FilePath customStylesheetFilePath = ((AbstractProject)build.getParent()).getModuleRoot().child(this.customStylesheet);
                cppUnitTransformer = new CppUnitTransformer(customStylesheetFilePath);
            } else {
                Messages.log(listener, "Use the default CppUnit plugin stylesheet.");
                cppUnitTransformer = new CppUnitTransformer();
            }
            File parentTargetJunitFile = Util.createTempDir();
            FilePath junitTargetFilePath = new FilePath(parentTargetJunitFile);
            if (junitTargetFilePath.exists()) {
                junitTargetFilePath.deleteRecursive();
            }
            junitTargetFilePath.mkdirs();
            FilePath[] moduleRoots = build.getProject().getModuleRoots();
            boolean multipleModuleRoots = moduleRoots != null && moduleRoots.length > 1;
            FilePath moduleRoot = multipleModuleRoots ? build.getProject().getWorkspace() : build.getProject().getModuleRoot();
            CppUnitArchiver archiver = new CppUnitArchiver(listener, junitTargetFilePath, this.testResultsPattern, cppUnitTransformer);
            result = (Boolean)moduleRoot.act((FilePath.FileCallable)archiver);
            if (!result) {
                build.setResult(Result.FAILURE);
            } else {
                result = this.recordTestResult(build, listener, junitTargetFilePath, "TEST-*.xml");
            }
            junitTargetFilePath.deleteRecursive();
        }
        catch (TransformerException te) {
            Messages.log(listener, "Error publishing cppunit results" + te.toString());
            build.setResult(Result.FAILURE);
        }
        Messages.log(listener, "End recording CppUnit tests results.");
        return result;
    }

    public CppUnitDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    private static FilePath getWorkspace(AbstractProject p) {
        try {
            return p.getWorkspace();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private boolean recordTestResult(AbstractBuild<?, ?> build, BuildListener listener, FilePath junitTargetFilePath, String junitFilePattern) throws InterruptedException, IOException {
        TestResultAction action;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        try {
            long buildTime = build.getTimestamp().getTimeInMillis();
            TestResult existingTestResults = null;
            if (existingAction != null) {
                existingTestResults = existingAction.getResult();
            }
            TestResult result = this.getTestResult(junitTargetFilePath, junitFilePattern, build, existingTestResults, buildTime);
            if (existingAction == null) {
                action = new TestResultAction(build, result, listener);
            } else {
                action = existingAction;
                action.setResult(result, listener);
            }
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                throw new AbortException("None of the test reports contained any result");
            }
        }
        catch (AbortException e) {
            if (build.getResult() == Result.FAILURE) {
                return true;
            }
            listener.getLogger().println(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        if (existingAction == null) {
            build.getActions().add(action);
        }
        if (action.getResult().getFailCount() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    private TestResult getTestResult(FilePath temporaryJunitFilePath, final String junitFilePattern, AbstractBuild<?, ?> build, final TestResult existingTestResults, final long buildTime) throws IOException, InterruptedException {
        final File temporaryJunitDirFile = new File(temporaryJunitFilePath.toURI());
        TestResult result = (TestResult)build.getProject().getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<TestResult>(){

            public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
                FileSet fs = Util.createFileSet((File)temporaryJunitDirFile, (String)junitFilePattern);
                DirectoryScanner ds = fs.getDirectoryScanner();
                String[] files = ds.getIncludedFiles();
                if (files.length == 0) {
                    throw new AbortException("No test report files were found. Configuration error?");
                }
                if (existingTestResults == null) {
                    return new TestResult(buildTime, ds);
                }
                existingTestResults.parse(buildTime, ds);
                return existingTestResults;
            }
        });
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CppUnitDescriptor
    extends BuildStepDescriptor<Publisher> {
        public CppUnitDescriptor() {
            super(CppUnitPublisher.class);
        }

        public String getDisplayName() {
            return "Publish CppUnit test result report";
        }

        public boolean isApplicable(Class type) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/cppunit/help.html";
        }

        public Publisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new CppUnitPublisher(req.getParameter("cppunit_reports.pattern"), req.getParameter("cppunit_reports.useCustomStylesheet") != null, req.getParameter("cppunit_reports.customStylesheet"));
        }

        public void doCheckValidCustomStylesheetLocation(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, true){

                public void check() throws IOException, ServletException {
                    String value = Util.fixEmptyAndTrim((String)this.request.getParameter("value"));
                    if (value != null) {
                        String job = Util.fixEmptyAndTrim((String)this.request.getParameter("job"));
                        FilePath workspace = CppUnitPublisher.getWorkspace((AbstractProject)Hudson.getInstance().getItemByFullName(job, AbstractProject.class));
                        File f = null;
                        try {
                            f = new File(new FilePath(workspace, value).toURI());
                        }
                        catch (InterruptedException ie) {
                            this.error(value + " is not a valid file.");
                            return;
                        }
                        if (!f.exists()) {
                            this.error(value + " is not a valid file.");
                            return;
                        }
                    } else {
                        this.error(" The stylesheet directory is mandatory.");
                    }
                    this.ok();
                }
            }.process();
        }
    }
}

