/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppunit;

import hudson.FilePath;
import hudson.Util;
import hudson.plugins.cppunit.CppUnitTransformer;
import hudson.plugins.cppunit.util.Messages;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppUnitArchiver
implements FilePath.FileCallable<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final PrintStream logger;
    private final FilePath junitTargetFilePath;
    private CppUnitTransformer reportTransformer;
    private final String pattern;

    public CppUnitArchiver(PrintStream logger, FilePath junitTargetFilePath, String pattern, CppUnitTransformer reportTransformer) throws TransformerException {
        this.logger = logger;
        this.junitTargetFilePath = junitTargetFilePath;
        this.pattern = pattern;
        this.reportTransformer = reportTransformer;
    }

    public Boolean invoke(File moduleRoot, VirtualChannel channel) throws IOException {
        String[] cppunitFiles = this.findCppUnitReports(moduleRoot);
        if (cppunitFiles.length == 0) {
            String msg = "No CppUnit test report file(s) were found with the pattern '" + this.pattern + "' relative to '" + moduleRoot + "'." + "  Did you enter a pattern relative to the correct directory?" + "  Did you generate the XML report(s) for CppUnit?";
            Messages.log((PrintStream)this.logger, (String)msg);
            return false;
        }
        Messages.log((PrintStream)this.logger, (String)("Processing " + cppunitFiles.length + " files with the pattern '" + this.pattern + "'."));
        for (String cppunitFileName : cppunitFiles) {
            FilePath fileCppunitReport = new FilePath(new File(moduleRoot, cppunitFileName));
            try {
                this.reportTransformer.transform(fileCppunitReport, this.junitTargetFilePath);
            }
            catch (Exception te) {
                throw new IOException2("Could not transform the CppUnit report.", (Throwable)te);
            }
        }
        return true;
    }

    private String[] findCppUnitReports(File parentPath) {
        FileSet fs = Util.createFileSet((File)parentPath, (String)this.pattern);
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] cppunitFiles = ds.getIncludedFiles();
        return cppunitFiles;
    }
}

