/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppunit;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.cppunit.CppUnitArchiver;
import hudson.plugins.cppunit.CppUnitTransformer;
import hudson.plugins.cppunit.Messages;
import hudson.plugins.cppunit.util.CppUnitLogUtil;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import net.sf.json.JSONObject;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppUnitPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final CppUnitDescriptor DESCRIPTOR = new CppUnitDescriptor();
    private String testResultsPattern = null;
    private boolean useWorkspaceBaseDir = false;

    public String getTestResultsPattern() {
        return this.testResultsPattern;
    }

    public void setTestResultsPattern(String testResultsPattern) {
        this.testResultsPattern = testResultsPattern;
    }

    public boolean isUseWorkspaceBaseDir() {
        return this.useWorkspaceBaseDir;
    }

    public void setUseWorkspaceBaseDir(boolean useWorkspaceBaseDir) {
        this.useWorkspaceBaseDir = useWorkspaceBaseDir;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new TestResultProjectAction(project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean recordingResult = false;
        try {
            CppUnitLogUtil.log(listener, "Recording of the CppUnit tests results.");
            CppUnitTransformer cppUnitTransformer = new CppUnitTransformer();
            FilePath junitTargetFilePath = new FilePath(build.getWorkspace(), "cppunitpluginTemp");
            if (junitTargetFilePath.exists()) {
                junitTargetFilePath.deleteRecursive();
            }
            junitTargetFilePath.mkdirs();
            FilePath basedir = null;
            if (this.useWorkspaceBaseDir) {
                basedir = build.getWorkspace();
            } else {
                FilePath[] moduleRoots = build.getModuleRoots();
                boolean multipleModuleRoots = moduleRoots != null && moduleRoots.length > 1;
                basedir = multipleModuleRoots ? build.getWorkspace() : build.getModuleRoot();
            }
            CppUnitArchiver archiver = new CppUnitArchiver(listener, junitTargetFilePath, this.testResultsPattern, cppUnitTransformer);
            Result result = (Result)basedir.act((FilePath.FileCallable)archiver);
            build.setResult(result);
            recordingResult = this.recordTestResult(build, basedir, listener, junitTargetFilePath, "TEST-*.xml");
            junitTargetFilePath.deleteRecursive();
        }
        catch (TransformerException te) {
            CppUnitLogUtil.log(listener, "[Error]- Recording of the CppUnit tests results. " + te.toString());
            build.setResult(Result.FAILURE);
        }
        CppUnitLogUtil.log(listener, "End recording of the CppUnit tests results.");
        return recordingResult;
    }

    public CppUnitDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    private boolean recordTestResult(AbstractBuild<?, ?> build, FilePath baseDirTestResult, BuildListener listener, FilePath junitTargetFilePath, String junitFilePattern) throws InterruptedException, IOException {
        TestResultAction action;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        try {
            long buildTime = build.getTimestamp().getTimeInMillis();
            long nowMaster = System.currentTimeMillis();
            TestResult existingTestResults = null;
            if (existingAction != null) {
                existingTestResults = existingAction.getResult();
            }
            TestResult result = (TestResult)baseDirTestResult.act((FilePath.FileCallable)new ParseResultCallable(junitTargetFilePath, junitFilePattern, existingTestResults, buildTime, nowMaster));
            if (existingAction == null) {
                action = new TestResultAction(build, result, listener);
            } else {
                action = existingAction;
                action.setResult(result, listener);
            }
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                throw new AbortException("None of the test reports contained any result");
            }
        }
        catch (AbortException e) {
            if (build.getResult() == Result.FAILURE) {
                return true;
            }
            listener.getLogger().println(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        if (existingAction == null) {
            build.getActions().add(action);
        }
        if (action.getResult().getFailCount() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ParseResultCallable
    implements FilePath.FileCallable<TestResult> {
        final FilePath temporaryJunitFilePath;
        final String junitFilePattern;
        final TestResult existingTestResults;
        long buildTime;
        long nowMaster;

        private ParseResultCallable(FilePath temporaryJunitFilePath, String junitFilePattern, TestResult existingTestResults, long buildTime, long nowMaster) {
            this.temporaryJunitFilePath = temporaryJunitFilePath;
            this.junitFilePattern = junitFilePattern;
            this.existingTestResults = existingTestResults;
            this.buildTime = buildTime;
            this.nowMaster = nowMaster;
        }

        public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
            long nowSlave = System.currentTimeMillis();
            File temporaryJunitDirFile = null;
            try {
                temporaryJunitDirFile = new File(this.temporaryJunitFilePath.toURI());
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            FileSet fs = Util.createFileSet(temporaryJunitDirFile, (String)this.junitFilePattern);
            DirectoryScanner ds = fs.getDirectoryScanner();
            String[] files = ds.getIncludedFiles();
            if (files.length == 0) {
                throw new AbortException("No test report files were found. Configuration error?");
            }
            if (this.existingTestResults == null) {
                return new TestResult(this.buildTime + (nowSlave - this.nowMaster), ds);
            }
            this.existingTestResults.parse(this.buildTime, ds);
            return this.existingTestResults;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CppUnitDescriptor
    extends BuildStepDescriptor<Publisher> {
        public CppUnitDescriptor() {
            super(CppUnitPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.cppUnit_PublisherName();
        }

        public boolean isApplicable(Class type) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/cppunit/help.html";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            CppUnitPublisher pub = new CppUnitPublisher();
            req.bindParameters((Object)pub, "cppunit_reports.");
            return pub;
        }
    }
}

