/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppunit;

import hudson.FilePath;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.cppunit.CppUnitTransformer;
import hudson.plugins.cppunit.util.Messages;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.transform.TransformerException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppUnitArchiver
implements FilePath.FileCallable<Result>,
Serializable {
    private static final long serialVersionUID = 1L;
    private BuildListener listener;
    private final FilePath junitTargetFilePath;
    private CppUnitTransformer reportTransformer;
    private final String pattern;

    public CppUnitArchiver(BuildListener listener, FilePath junitTargetFilePath, String pattern, CppUnitTransformer reportTransformer) throws TransformerException {
        this.listener = listener;
        this.junitTargetFilePath = junitTargetFilePath;
        this.pattern = pattern;
        this.reportTransformer = reportTransformer;
    }

    public Result invoke(File basedir, VirtualChannel channel) throws IOException {
        String[] cppunitFiles = this.findCppUnitReports(basedir);
        if (cppunitFiles.length == 0) {
            String msg = "No CppUnit test report file(s) were found with the pattern '" + this.pattern + "' relative to '" + basedir + "'." + "  Did you enter a pattern relative to the correct directory?" + "  Did you generate the XML report(s) for CppUnit?";
            Messages.log((BuildListener)this.listener, (String)msg);
            return Result.FAILURE;
        }
        Messages.log((BuildListener)this.listener, (String)("Processing " + cppunitFiles.length + " files with the pattern '" + this.pattern + "'."));
        boolean hasInvalidateFiles = false;
        for (String cppunitFileName : cppunitFiles) {
            File fileCppunitReportFile = new File(basedir, cppunitFileName);
            if (fileCppunitReportFile.length() == 0L) {
                String msg = "[WARNING] - The file '" + fileCppunitReportFile.getPath() + "' is empty. This file has been ignored.";
                Messages.log((BuildListener)this.listener, (String)msg);
                continue;
            }
            if (!this.validateCppunitResultFile(fileCppunitReportFile)) {
                hasInvalidateFiles = true;
                Messages.log((BuildListener)this.listener, (String)("[WARNING] - The file '" + fileCppunitReportFile + "' is an invalid file. It has been ignored."));
                continue;
            }
            try {
                FilePath fileCppunitReport = new FilePath(fileCppunitReportFile);
                this.reportTransformer.transform(fileCppunitReport, this.junitTargetFilePath);
            }
            catch (Exception te) {
                throw new IOException2("Could not transform the CppUnit report.", (Throwable)te);
            }
        }
        return hasInvalidateFiles ? Result.UNSTABLE : Result.SUCCESS;
    }

    private boolean validateCppunitResultFile(File fileCppunitReportFile) throws FactoryConfigurationError {
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.parse(fileCppunitReportFile);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String[] findCppUnitReports(File parentPath) {
        FileSet fs = Util.createFileSet((File)parentPath, (String)this.pattern);
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] cppunitFiles = ds.getIncludedFiles();
        return cppunitFiles;
    }
}

