/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppunit;

import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;

public class CppUnitTransformer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Transformer cppunitXMLTransformer;
    private static final String JUNIT_FILE_POSTFIX = ".xml";
    private static final String JUNIT_FILE_PREFIX = "TEST-";
    public static final String CPPUNIT_TO_JUNIT_XSL = "cppunit-to-junit.xsl";

    public void transform(FilePath cppunitFileName, FilePath junitOutputPath) throws IOException, TransformerException, SAXException, ParserConfigurationException, InterruptedException, IOException {
        this.initializeProcessor();
        FilePath junitTargetFile = new FilePath(junitOutputPath, JUNIT_FILE_PREFIX + cppunitFileName.hashCode() + JUNIT_FILE_POSTFIX);
        this.cppunitXMLTransformer.transform(new StreamSource(new File(cppunitFileName.toURI())), new StreamResult(new File(junitTargetFile.toURI())));
    }

    private void initializeProcessor() throws TransformerFactoryConfigurationError, TransformerConfigurationException, ParserConfigurationException, InterruptedException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StreamSource streamSourceXSL = new StreamSource(this.getClass().getResourceAsStream(CPPUNIT_TO_JUNIT_XSL));
        this.cppunitXMLTransformer = transformerFactory.newTransformer(streamSourceXSL);
    }
}

