/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crap4j.reader;

import com.schneide.crap4j.crap.MethodCrapManager;
import com.schneide.crap4j.reader.ReportReader;
import com.schneide.crap4j.reader.model.ICrapReport;
import com.schneide.crap4j.reader.model.IMethod;
import com.schneide.crap4j.reader.model.IMethodCrapData;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ReportReader {
    private final Reader reportData;
    private final MethodCrapManager methodCrapManager;
    private ParsedCrapReport parsedData;

    public ReportReader(Reader reportData) {
        this.reportData = reportData;
        this.methodCrapManager = new MethodCrapManager();
        this.parsedData = null;
    }

    public synchronized ICrapReport parseData() throws IOException {
        if (null != this.parsedData) {
            return this.parsedData;
        }
        try {
            SAXBuilder saxBuilder = new SAXBuilder(false);
            Document build = saxBuilder.build(this.reportData);
            Element rootElement = build.getRootElement();
            ParsedStatistics statistics = this.parseStatistics(rootElement);
            ParsedCrap4JData details = this.parseDetails(rootElement);
            this.parsedData = new ParsedCrapReport(this, statistics, details);
            return this.parsedData;
        }
        catch (JDOMException e) {
            throw new IOException(e);
        }
    }

    private ParsedStatistics parseStatistics(Element rootElement) {
        Element statsElement = rootElement.getChild("stats");
        ParsedStatistics result = new ParsedStatistics(this, this.readTextualContent(statsElement, "name"), Integer.parseInt(this.readTextualContent(statsElement, "methodCount")), Integer.parseInt(this.readTextualContent(statsElement, "crapMethodCount")), Integer.parseInt(this.readTextualContent(statsElement, "crapLoad")), Double.parseDouble(this.readTextualContent(statsElement, "totalCrap")), Double.parseDouble(this.readTextualContent(statsElement, "crapMethodPercent")));
        return result;
    }

    private ParsedCrap4JData parseDetails(Element rootElement) {
        Element methodsElement = rootElement.getChild("methods");
        List methodElements = methodsElement.getChildren("method");
        for (Object object : methodElements) {
            IMethodCrapData crapData = this.parseMethodCrap((Element)object);
            this.methodCrapManager.addMethodCrapData(crapData);
        }
        return new ParsedCrap4JData(this);
    }

    private IMethodCrapData parseMethodCrap(Element methodElement) {
        IMethod method = this.parseMethod(methodElement);
        double crap = Double.parseDouble(this.readTextualContent(methodElement, "crap"));
        int crapLoad = Integer.parseInt(this.readTextualContent(methodElement, "crapLoad"));
        double coverage = Double.parseDouble(this.readTextualContent(methodElement, "coverage"));
        double complexity = Double.parseDouble(this.readTextualContent(methodElement, "complexity"));
        return new MethodCrapData(this, method, crap, crapLoad, coverage, complexity);
    }

    private String readTextualContent(Element element, String subTagName) {
        return element.getChildText(subTagName).trim();
    }

    private IMethod parseMethod(Element methodElement) {
        return new ParsedMethod(this.readTextualContent(methodElement, "package"), this.readTextualContent(methodElement, "className"), this.readTextualContent(methodElement, "methodName"), this.readTextualContent(methodElement, "methodSignature"), this.readTextualContent(methodElement, "fullMethod"));
    }

    static /* synthetic */ MethodCrapManager access$000(ReportReader x0) {
        return x0.methodCrapManager;
    }
}

