/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.crap4j.chart;

import hudson.plugins.crap4j.CrapBuildResult;
import hudson.plugins.crap4j.chart.ChartSeriesDefinition;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import org.jfree.data.category.CategoryDataset;

public class CrapDataSet {
    private final CrapBuildResult report;

    public CrapDataSet(CrapBuildResult report) {
        this.report = report;
    }

    public CategoryDataset buildCategoryDataSet(ChartSeriesDefinition extractor) {
        Row dataRow = new Row(extractor.getDenotation(), 0);
        DataSetBuilder builder = new DataSetBuilder();
        for (CrapBuildResult currentReport = this.report; null != currentReport; currentReport = currentReport.getPrevious()) {
            builder.add(extractor.extractNumberFrom(currentReport.getResultData()), (Comparable)dataRow, (Comparable)new ChartUtil.NumberOnlyBuildLabel(currentReport.getOwner()));
        }
        return builder.build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Row
    implements Comparable<Row> {
        private final String tag;
        private final int number;

        public Row(String tag, int number) {
            this.tag = tag;
            this.number = number;
        }

        public String toString() {
            return this.tag;
        }

        @Override
        public int compareTo(Row other) {
            return this.number == other.number ? 0 : (this.number < other.number ? 1 : -1);
        }
    }
}

