/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.crap4j.model;

import com.schneide.crap4j.reader.model.IMethod;
import com.schneide.crap4j.reader.model.IMethodCrapData;
import hudson.plugins.crap4j.model.IMethodCrap;
import java.io.Serializable;

public class MethodCrapBean
implements Serializable,
IMethodCrap {
    private static final long serialVersionUID = 6853892607068654098L;
    private final String packageName;
    private final String className;
    private final String methodName;
    private final String methodSignature;
    private final String fullMethod;
    private final double crap;
    private final double complexity;
    private final double coveragePercent;
    private final int crapLoad;

    public MethodCrapBean(IMethodCrapData crapData) {
        this.packageName = ((IMethod)crapData.getContext()).getPackageName();
        this.className = ((IMethod)crapData.getContext()).getClassName();
        this.methodName = MethodCrapBean.getMethodNameFrom(((IMethod)crapData.getContext()).getName());
        this.methodSignature = ((IMethod)crapData.getContext()).getSignature();
        this.fullMethod = ((IMethod)crapData.getContext()).getFullMethod();
        this.crap = crapData.getCrap();
        this.complexity = crapData.getComplexity();
        this.coveragePercent = crapData.getCoverage();
        this.crapLoad = crapData.getCrapLoad();
    }

    private static String getMethodNameFrom(String contextName) {
        if (contextName.isEmpty()) {
            return "(init)";
        }
        if ("<init>".equals(contextName)) {
            return "(init)";
        }
        return contextName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public String getFullMethod() {
        return this.fullMethod;
    }

    public double getCrap() {
        return this.crap;
    }

    public double getComplexity() {
        return this.complexity;
    }

    public double getCoveragePercent() {
        return this.coveragePercent;
    }

    public int getCrapLoad() {
        return this.crapLoad;
    }
}

