/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.crap4j.calculation;

import hudson.plugins.crap4j.display.ICrapComparison;
import hudson.plugins.crap4j.model.IMethodCrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrapDataComparer
implements ICrapComparison {
    private final List<IMethodCrap> newMethods = new ArrayList();
    private final List<IMethodCrap> fixedMethods = new ArrayList();
    private final List<IMethodCrap> unchangedMethods = new ArrayList();

    public CrapDataComparer(IMethodCrap[] oldCrapMethods, IMethodCrap[] newCrapMethods) {
        this.performComparison(oldCrapMethods, newCrapMethods);
    }

    private Map<String, IMethodCrap> createCrapMethodMapFor(IMethodCrap ... crapMethods) {
        HashMap<String, IMethodCrap> result = new HashMap<String, IMethodCrap>();
        for (IMethodCrap methodCrap : crapMethods) {
            result.put(this.getUniqueNameOf(methodCrap), methodCrap);
        }
        return result;
    }

    private String getUniqueNameOf(IMethodCrap method) {
        StringBuilder result = new StringBuilder();
        result.append(method.getPackageName());
        result.append(".");
        result.append(method.getClassName());
        result.append(".");
        result.append(method.getMethodName());
        result.append(":");
        result.append(method.getMethodSignature());
        return result.toString();
    }

    private void performComparison(IMethodCrap[] oldCrapMethods, IMethodCrap[] newCrapMethods) {
        Map oldCrapMethodMap = this.createCrapMethodMapFor(oldCrapMethods);
        Map newCrapMethodMap = this.createCrapMethodMapFor(newCrapMethods);
        Set entrySet = oldCrapMethodMap.entrySet();
        for (Map.Entry entry : entrySet) {
            if (newCrapMethodMap.containsKey(entry.getKey())) {
                this.unchangedMethods.add(entry.getValue());
                newCrapMethodMap.remove(entry.getKey());
                continue;
            }
            this.fixedMethods.add(entry.getValue());
        }
        this.newMethods.addAll(newCrapMethodMap.values());
    }

    public IMethodCrap[] getFixedCrapMethods() {
        return this.getAsArray(this.fixedMethods);
    }

    private IMethodCrap[] getAsArray(List<IMethodCrap> methodList) {
        return methodList.toArray(new IMethodCrap[methodList.size()]);
    }

    public IMethodCrap[] getNewCrapMethods() {
        return this.getAsArray(this.newMethods);
    }

    public IMethodCrap[] getUnchangedCrapMethods() {
        return this.getAsArray(this.unchangedMethods);
    }
}

