/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crap4j.crap;

import com.schneide.crap4j.reader.model.IContextedCrapData;
import com.schneide.crap4j.reader.model.ICrapData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericCrapData<O>
implements IContextedCrapData<O> {
    private final O context;
    private final int crappyMethods;
    private final int totalMethods;
    private final double crap;
    private final int crapLoad;
    private final double coverage;
    private final double complexity;

    public GenericCrapData(O context, ICrapData data) {
        this(context, data.getCrappyMethods(), data.getTotalMethods(), data.getCrap(), data.getCrapLoad(), data.getCoverage(), data.getComplexity());
    }

    public GenericCrapData(O context, int crappyMethods, int totalMethods, double crap, int crapLoad, double coverage, double complexity) {
        this.context = context;
        this.crappyMethods = crappyMethods;
        this.totalMethods = totalMethods;
        this.crap = crap;
        this.crapLoad = crapLoad;
        this.coverage = coverage;
        this.complexity = complexity;
    }

    public O getContext() {
        return (O)this.context;
    }

    public double getCoverage() {
        return this.coverage;
    }

    public double getCrap() {
        return this.crap;
    }

    public int getCrapLoad() {
        return this.crapLoad;
    }

    public int getCrappyMethods() {
        return this.crappyMethods;
    }

    public int getTotalMethods() {
        return this.totalMethods;
    }

    public double getCrapPercentage() {
        return (double)this.getCrappyMethods() / (double)this.getTotalMethods();
    }

    public double getComplexity() {
        return this.complexity;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(String.valueOf(this.getContext()));
        result.append(": crapPercentage=");
        result.append(this.getCrapPercentage());
        result.append(", crap=");
        result.append(this.getCrap());
        result.append(", crapLoad=");
        result.append(this.getCrapLoad());
        result.append(", coverage=");
        result.append(this.getCoverage());
        result.append(", complexity=");
        result.append(this.getComplexity());
        return result.toString();
    }
}

