/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.crap4j.chart;

import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

public abstract class AbstractChartMaker {
    private static final double PADDING = 5.0;

    public JFreeChart createChart(CategoryDataset dataset, String rangeAxisTitle) {
        JFreeChart result = this.createRawChart(dataset, rangeAxisTitle);
        result.setBackgroundPaint((Paint)Color.WHITE);
        this.setupPlot(result.getCategoryPlot());
        return result;
    }

    protected abstract JFreeChart createRawChart(CategoryDataset var1, String var2);

    protected void setupPlot(CategoryPlot plot) {
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.BLACK);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        this.setupRangeAxis((NumberAxis)plot.getRangeAxis());
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
    }

    protected void setupRangeAxis(NumberAxis rangeAxis) {
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setLowerBound(0.0);
    }
}

