/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.crap4j.calculation;

import hudson.model.HealthReport;
import hudson.plugins.crap4j.model.ProjectCrapBean;

public class HealthBuilder {
    private final double threshold;

    public HealthBuilder() {
        this(15.0);
    }

    public HealthBuilder(double threshold) {
        this.threshold = threshold;
        if (this.threshold <= 0.0) {
            throw new IllegalArgumentException("The threshold needs to be positive, and not " + this.threshold);
        }
    }

    public double getThreshold() {
        return this.threshold;
    }

    public HealthReport getHealthReportFor(ProjectCrapBean crap) {
        return new HealthReport((int)Math.round(this.calculateHealthOf(crap.getCrapMethodPercent())), this.getHealthSummary(crap.getCrapMethodCount(), crap.getCrapMethodPercent()));
    }

    protected double calculateHealthOf(double crapMethodPercentage) {
        double result = 100.0 - 100.0 * (crapMethodPercentage / this.threshold);
        return Math.min(100.0, Math.max(0.0, result));
    }

    protected String getHealthSummary(int crapMethodCount, double crapMethodPercentage) {
        StringBuilder result = new StringBuilder();
        result.append(crapMethodCount);
        result.append(" crappy methods (");
        result.append(crapMethodPercentage);
        result.append("%)");
        return result.toString();
    }
}

