/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crap4j.reader;

import com.schneide.crap4j.crap.GenericCrapData;
import com.schneide.crap4j.crap.MethodCrapManager;
import com.schneide.crap4j.reader.model.ICrapDetails;
import com.schneide.crap4j.reader.model.ICrapReport;
import com.schneide.crap4j.reader.model.IMethod;
import com.schneide.crap4j.reader.model.IMethodCrapData;
import com.schneide.crap4j.reader.model.IOverallStatistics;
import com.schneide.crap4j.reader.util.NumericalParser;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ReportReader {
    private final Reader reportData;
    private final MethodCrapManager methodCrapManager;
    private ParsedCrapReport parsedData;

    public ReportReader(Reader reportData) {
        this.reportData = reportData;
        this.methodCrapManager = new MethodCrapManager();
        this.parsedData = null;
    }

    public synchronized ICrapReport parseData() throws IOException {
        if (null != this.parsedData) {
            return this.parsedData;
        }
        try {
            SAXBuilder saxBuilder = new SAXBuilder(false);
            Document build = saxBuilder.build(this.reportData);
            Element rootElement = build.getRootElement();
            ParsedStatistics statistics = this.parseStatistics(rootElement);
            ParsedCrap4JData details = this.parseDetails(rootElement);
            this.parsedData = new ParsedCrapReport(statistics, details);
            return this.parsedData;
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
    }

    private ParsedStatistics parseStatistics(Element rootElement) {
        Element statsElement = rootElement.getChild("stats");
        NumericalParser parser = new NumericalParser();
        ParsedStatistics result = new ParsedStatistics(this.readTextualContent(statsElement, "name"), parser.parseInt(this.readTextualContent(statsElement, "methodCount")), parser.parseInt(this.readTextualContent(statsElement, "crapMethodCount")), parser.parseInt(this.readTextualContent(statsElement, "crapLoad")), parser.parseDouble(this.readTextualContent(statsElement, "totalCrap")), parser.parseDouble(this.readTextualContent(statsElement, "crapMethodPercent")));
        return result;
    }

    private ParsedCrap4JData parseDetails(Element rootElement) {
        Element methodsElement = rootElement.getChild("methods");
        List methodElements = methodsElement.getChildren("method");
        for (Object object : methodElements) {
            IMethodCrapData crapData = this.parseMethodCrap((Element)object);
            this.methodCrapManager.addMethodCrapData(crapData);
        }
        return new ParsedCrap4JData();
    }

    private IMethodCrapData parseMethodCrap(Element methodElement) {
        IMethod method = this.parseMethod(methodElement);
        NumericalParser parser = new NumericalParser();
        double crap = parser.parseDouble(this.readTextualContent(methodElement, "crap"));
        int crapLoad = parser.parseInt(this.readTextualContent(methodElement, "crapLoad"));
        double coverage = parser.parseDouble(this.readTextualContent(methodElement, "coverage"));
        double complexity = parser.parseDouble(this.readTextualContent(methodElement, "complexity"));
        return new MethodCrapData(method, crap, crapLoad, coverage, complexity);
    }

    private String readTextualContent(Element element, String subTagName) {
        String childText = element.getChildText(subTagName);
        if (null == childText) {
            System.err.println("Got null content for " + subTagName);
            return null;
        }
        return childText.trim();
    }

    private IMethod parseMethod(Element methodElement) {
        return new ParsedMethod(this.readTextualContent(methodElement, "package"), this.readTextualContent(methodElement, "className"), this.readTextualContent(methodElement, "methodName"), this.readTextualContent(methodElement, "methodSignature"), this.readTextualContent(methodElement, "fullMethod"));
    }

    private static class ParsedMethod
    implements IMethod {
        private final String packageName;
        private final String className;
        private final String methodName;
        private final String signature;
        private final String fullMethod;

        public ParsedMethod(String packageName, String className, String methodName, String signature, String fullMethod) {
            this.packageName = packageName;
            this.className = className;
            this.methodName = methodName;
            this.signature = signature;
            this.fullMethod = fullMethod;
        }

        public String getClassName() {
            return this.className;
        }

        public String getFullMethod() {
            return this.fullMethod;
        }

        public String getName() {
            return this.methodName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getSignature() {
            return this.signature;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodCrapData
    extends GenericCrapData<IMethod>
    implements IMethodCrapData {
        public MethodCrapData(IMethod context, double crap, int crapLoad, double coverage, double complexity) {
            super(context, 0, 1, crap, crapLoad, coverage, complexity);
        }

        @Override
        public int getCrappyMethods() {
            if (this.isCrappy()) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean isCrappy() {
            return this.getCrapLoad() > 0;
        }

        @Override
        public double getCrapPercentage() {
            if (this.isCrappy()) {
                return 1.0;
            }
            return 0.0;
        }
    }

    private class ParsedCrap4JData
    implements ICrapDetails {
        public MethodCrapManager getMethodCrapManager() {
            return ReportReader.this.methodCrapManager;
        }
    }

    private class ParsedStatistics
    implements IOverallStatistics {
        private final String name;
        private final int methodCount;
        private final int crapMethodCount;
        private final int crapLoad;
        private final double totalCrap;
        private final double crapMethodPercent;

        public ParsedStatistics(String name, int methodCount, int crapMethodCount, int crapLoad, double totalCrap, double crapMethodPercent) {
            this.name = name;
            this.methodCount = methodCount;
            this.crapMethodCount = crapMethodCount;
            this.crapLoad = crapLoad;
            this.totalCrap = totalCrap;
            this.crapMethodPercent = crapMethodPercent;
        }

        public int getCrapLoad() {
            return this.crapLoad;
        }

        public int getCrapMethodCount() {
            return this.crapMethodCount;
        }

        public double getCrapMethodPercent() {
            return this.crapMethodPercent;
        }

        public int getMethodCount() {
            return this.methodCount;
        }

        public String getName() {
            return this.name;
        }

        public double getTotalCrap() {
            return this.totalCrap;
        }
    }

    private class ParsedCrapReport
    implements ICrapReport {
        private final ParsedCrap4JData data;
        private final ParsedStatistics statistics;

        public ParsedCrapReport(ParsedStatistics statistics, ParsedCrap4JData data) {
            this.statistics = statistics;
            this.data = data;
        }

        public ICrapDetails getDetails() {
            return this.data;
        }

        public IOverallStatistics getStatistics() {
            return this.statistics;
        }
    }
}

