/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.crap4j.util;

import hudson.FilePath;
import hudson.plugins.crap4j.util.FileSetBuilder;
import hudson.plugins.crap4j.util.FoundFile;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportFilesFinder
implements FilePath.FileCallable<FoundFile[]> {
    private static final long serialVersionUID = -1666598324699232787L;
    private final boolean isSkippingOldFiles;
    private final String pattern;

    public ReportFilesFinder(String pattern) {
        this(pattern, false);
    }

    public ReportFilesFinder(String pattern, boolean isSkippingOldFiles) {
        this.pattern = pattern;
        this.isSkippingOldFiles = isSkippingOldFiles;
    }

    public FoundFile[] invoke(File workspaceRoot, VirtualChannel channel) throws IOException {
        return this.getFilesFor(workspaceRoot);
    }

    private String[] getRelativePaths(File workspaceRoot) {
        FileSetBuilder builder = new FileSetBuilder(workspaceRoot);
        FileSet fileSet = builder.createFileSetFor(this.pattern);
        return fileSet.getDirectoryScanner().getIncludedFiles();
    }

    private FoundFile[] getFoundFiles(File workspaceRoot) {
        String[] relativePaths = this.getRelativePaths(workspaceRoot);
        FoundFile[] result = new FoundFile[relativePaths.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new FoundFile(new FilePath(new File(workspaceRoot, relativePaths[i])), relativePaths[i]);
        }
        return result;
    }

    private boolean isAcceptable(FoundFile file) {
        return true;
    }

    public FoundFile[] getFilesFor(File workspaceRoot) {
        FoundFile[] rawFindings = this.getFoundFiles(workspaceRoot);
        ArrayList<FoundFile> result = new ArrayList<FoundFile>();
        for (FoundFile foundFile : rawFindings) {
            if (!this.isAcceptable(foundFile)) continue;
            result.add(foundFile);
        }
        return result.toArray(new FoundFile[result.size()]);
    }
}

