/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.crap4j;

import com.schneide.crap4j.reader.ReportReader;
import com.schneide.crap4j.reader.model.ICrapReport;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.crap4j.Crap4JBuildAction;
import hudson.plugins.crap4j.Crap4JPluginDescriptor;
import hudson.plugins.crap4j.Crap4JProjectAction;
import hudson.plugins.crap4j.CrapBuildResult;
import hudson.plugins.crap4j.calculation.HealthBuilder;
import hudson.plugins.crap4j.model.CrapReportMerger;
import hudson.plugins.crap4j.model.ProjectCrapBean;
import hudson.plugins.crap4j.util.FoundFile;
import hudson.plugins.crap4j.util.ReportFilesFinder;
import hudson.tasks.Publisher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Crap4JPublisher
extends Publisher {
    private static final Logger LOGGER = Logger.getLogger(Crap4JPublisher.class.getName());
    public static final Crap4JPluginDescriptor DESCRIPTOR = new Crap4JPluginDescriptor();
    private final String reportPattern;
    private HealthBuilder healthBuilder;

    public Crap4JPublisher(String reportPattern, String healthThreshold) {
        this.reportPattern = reportPattern;
        this.healthBuilder = this.getHealthBuilderFor(healthThreshold);
    }

    private HealthBuilder getHealthBuilderFor(String healthThreshold) {
        if (null == healthThreshold) {
            return DESCRIPTOR.getHealthBuilder();
        }
        try {
            return new HealthBuilder(Double.parseDouble(healthThreshold));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.WARNING, "Could not parse health threshold representation to a number: " + healthThreshold, e);
            return DESCRIPTOR.getHealthBuilder();
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, "Not a valid health threshold: " + healthThreshold, e);
            return DESCRIPTOR.getHealthBuilder();
        }
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new Crap4JProjectAction(project);
    }

    protected void log(PrintStream logger, String message) {
        logger.println("[CRAP4J] " + message);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        this.log(logger, "Collecting Crap4J analysis files...");
        this.log(logger, "Searching for report files within " + this.reportPattern);
        this.log(logger, "Using the new FileSetBuilder");
        ReportFilesFinder finder = new ReportFilesFinder(this.reportPattern);
        FoundFile[] reports = (FoundFile[])build.getProject().getWorkspace().act((FilePath.FileCallable)finder);
        if (0 == reports.length) {
            this.log(logger, "No crap4j report files were found. Configuration error?");
            return false;
        }
        ProjectCrapBean previousCrap = this.getPreviousProjectCrapBean(build);
        ProjectCrapBean reportBean = this.createCurrentProjectCrapBean(logger, reports, previousCrap);
        build.getActions().add(new Crap4JBuildAction(build, new CrapBuildResult(build, reportBean), this.healthBuilder));
        return true;
    }

    private ProjectCrapBean getPreviousProjectCrapBean(AbstractBuild<?, ?> build) {
        CrapBuildResult previousResult = CrapBuildResult.getPrevious(build);
        if (null != previousResult) {
            return previousResult.getResultData();
        }
        return null;
    }

    private ProjectCrapBean createCurrentProjectCrapBean(PrintStream logger, FoundFile[] reports, ProjectCrapBean previousCrap) throws UnsupportedEncodingException, IOException {
        ProjectCrapBean[] currentBeans = this.loadProjectCrapBeans(logger, reports, previousCrap);
        if (1 == currentBeans.length) {
            return currentBeans[0];
        }
        CrapReportMerger merger = new CrapReportMerger();
        return merger.mergeReports(previousCrap, currentBeans);
    }

    private ProjectCrapBean[] loadProjectCrapBeans(PrintStream logger, FoundFile[] reports, ProjectCrapBean previousCrap) throws UnsupportedEncodingException, IOException {
        ArrayList<ProjectCrapBean> result = new ArrayList<ProjectCrapBean>();
        for (FoundFile currentReportFile : reports) {
            BufferedReader reportReader = new BufferedReader(new InputStreamReader(currentReportFile.getFile().read(), currentReportFile.getEncoding()));
            ReportReader parser = new ReportReader(reportReader);
            ICrapReport report = parser.parseData();
            ProjectCrapBean reportBean = new ProjectCrapBean(previousCrap, report.getStatistics(), report.getDetails().getMethodCrapManager().getAllCrapData());
            this.log(logger, "Got a report bean with " + reportBean.getCrapMethodCount() + " crap methods out of " + reportBean.getMethodCount() + " methods.");
            result.add(reportBean);
        }
        return result.toArray(new ProjectCrapBean[result.size()]);
    }

    public String getReportPattern() {
        return this.reportPattern;
    }

    public String getHealthThreshold() {
        return String.valueOf(this.healthBuilder.getThreshold());
    }
}

