/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.crap4j.model;

import com.schneide.crap4j.reader.model.IOverallStatistics;
import hudson.plugins.crap4j.model.IMethodCrap;
import hudson.plugins.crap4j.model.ProjectCrapBean;
import java.util.ArrayList;
import java.util.Collections;

public class CrapReportMerger {
    public ProjectCrapBean mergeReports(ProjectCrapBean previous, ProjectCrapBean ... beans) {
        ArrayList crapMethods = new ArrayList();
        for (ProjectCrapBean crapBean : beans) {
            Collections.addAll(crapMethods, crapBean.getCrapMethods());
        }
        ProjectCrapBean result = new ProjectCrapBean(previous, (IOverallStatistics)new MergedOverallStatistics(beans), crapMethods.toArray(new IMethodCrap[crapMethods.size()]));
        return result;
    }

    private static class MergedOverallStatistics
    implements IOverallStatistics {
        private final ProjectCrapBean[] beans;

        public MergedOverallStatistics(ProjectCrapBean ... beans) {
            this.beans = beans;
        }

        public int getCrapLoad() {
            int result = 0;
            for (ProjectCrapBean crapBean : this.beans) {
                result += crapBean.getCrapLoad();
            }
            return result;
        }

        public int getCrapMethodCount() {
            int result = 0;
            for (ProjectCrapBean crapBean : this.beans) {
                result += crapBean.getCrapMethodCount();
            }
            return result;
        }

        public double getCrapMethodPercent() {
            return (double)this.getCrapMethodCount() / (double)this.getMethodCount() * 100.0;
        }

        public int getMethodCount() {
            int result = 0;
            for (ProjectCrapBean crapBean : this.beans) {
                result += crapBean.getMethodCount();
            }
            return result;
        }

        public String getName() {
            StringBuilder result = new StringBuilder();
            result.append("report merged from ");
            for (ProjectCrapBean crapBean : this.beans) {
                result.append(crapBean.getName());
                result.append(", ");
            }
            return result.toString();
        }

        public double getTotalCrap() {
            double result = 0.0;
            for (ProjectCrapBean crapBean : this.beans) {
                result += crapBean.getTotalCrap();
            }
            return result;
        }
    }
}

