/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crap4j.reader;

import com.schneide.crap4j.crap.MethodCrapManager;
import com.schneide.crap4j.reader.ReportReader;
import com.schneide.crap4j.reader.model.ICrapReport;
import com.schneide.crap4j.reader.model.IMethod;
import com.schneide.crap4j.reader.model.IMethodCrapData;
import com.schneide.crap4j.reader.util.NumericalParser;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ReportReader {
    private final Reader reportData;
    private final MethodCrapManager methodCrapManager;
    private ParsedCrapReport parsedData;
    private static final MethodCrapData IRRELEVANT_ENTRY = new MethodCrapData(null, 0.0, 0, 0.0, 0.0);

    public ReportReader(Reader reportData) {
        this.reportData = reportData;
        this.methodCrapManager = new MethodCrapManager();
        this.parsedData = null;
    }

    public synchronized ICrapReport parseData() throws IOException {
        if (null != this.parsedData) {
            return this.parsedData;
        }
        try {
            SAXBuilder saxBuilder = new SAXBuilder(false);
            Document build = saxBuilder.build(this.reportData);
            Element rootElement = build.getRootElement();
            ParsedStatistics statistics = this.parseStatistics(rootElement);
            ParsedCrap4JData details = this.parseDetails(rootElement);
            this.parsedData = new ParsedCrapReport(this, statistics, details);
            return this.parsedData;
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
    }

    private ParsedStatistics parseStatistics(Element rootElement) {
        Element statsElement = rootElement.getChild("stats");
        NumericalParser parser = new NumericalParser();
        ParsedStatistics result = new ParsedStatistics(this, this.readTextualContent(statsElement, "name"), parser.parseInt(this.readTextualContent(statsElement, "methodCount")), parser.parseInt(this.readTextualContent(statsElement, "crapMethodCount")), parser.parseInt(this.readTextualContent(statsElement, "crapLoad")), parser.parseDouble(this.readTextualContent(statsElement, "totalCrap")), parser.parseDouble(this.readTextualContent(statsElement, "crapMethodPercent")));
        return result;
    }

    private ParsedCrap4JData parseDetails(Element rootElement) {
        Element methodsElement = rootElement.getChild("methods");
        List methodElements = methodsElement.getChildren("method");
        for (Object object : methodElements) {
            IMethodCrapData crapData = this.parseMethodCrap((Element)object);
            if (IRRELEVANT_ENTRY == crapData) continue;
            this.methodCrapManager.addMethodCrapData(crapData);
        }
        return new ParsedCrap4JData(this);
    }

    private IMethodCrapData parseMethodCrap(Element methodElement) {
        IMethod method = this.parseMethod(methodElement);
        NumericalParser parser = new NumericalParser();
        int crapLoad = parser.parseInt(this.readTextualContent(methodElement, "crapLoad"));
        if (0 == crapLoad) {
            return IRRELEVANT_ENTRY;
        }
        double crap = parser.parseDouble(this.readTextualContent(methodElement, "crap"));
        double coverage = parser.parseDouble(this.readTextualContent(methodElement, "coverage"));
        double complexity = parser.parseDouble(this.readTextualContent(methodElement, "complexity"));
        return new MethodCrapData(method, crap, crapLoad, coverage, complexity);
    }

    private String readTextualContent(Element element, String subTagName) {
        String childText = element.getChildText(subTagName);
        if (null == childText) {
            System.err.println("Got null content for " + subTagName);
            return null;
        }
        return childText.trim();
    }

    private IMethod parseMethod(Element methodElement) {
        return new ParsedMethod(this.readTextualContent(methodElement, "package"), this.readTextualContent(methodElement, "className"), this.readTextualContent(methodElement, "methodName"), this.readTextualContent(methodElement, "methodSignature"), this.readTextualContent(methodElement, "fullMethod"));
    }

    static /* synthetic */ MethodCrapManager access$000(ReportReader x0) {
        return x0.methodCrapManager;
    }
}

