/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.crap4j;

import com.thoughtworks.xstream.XStream;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.model.ModelObject;
import hudson.plugins.crap4j.Crap4JBuildAction;
import hudson.plugins.crap4j.FixedCrapMethodsResult;
import hudson.plugins.crap4j.NewCrapMethodsResult;
import hudson.plugins.crap4j.display.DecreasingCrapLoadComparator;
import hudson.plugins.crap4j.model.ICrapMethodPresentation;
import hudson.plugins.crap4j.model.IMethodCrap;
import hudson.plugins.crap4j.model.ProjectCrapBean;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrapBuildResult
implements ModelObject,
ICrapMethodPresentation {
    private transient WeakReference<ProjectCrapBean> crap;
    private AbstractBuild<?, ?> owner;
    private static final Logger LOGGER = Logger.getLogger(CrapBuildResult.class.getName());
    private static final XStream XSTREAM = new XStream2();

    public CrapBuildResult(AbstractBuild<?, ?> owner, ProjectCrapBean crap) {
        this.owner = owner;
        this.crap = new WeakReference<ProjectCrapBean>(crap);
        try {
            this.getDataFile().write((Object)crap);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to serialize the crap4j result.", e);
        }
    }

    public void setOwner(AbstractBuild<?, ?> owner) {
        this.owner = owner;
    }

    @Override
    public AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public ProjectCrapBean getResultData() {
        ProjectCrapBean result;
        if (null == this.crap) {
            this.loadCrap();
        }
        if (null == (result = (ProjectCrapBean)this.crap.get())) {
            this.loadCrap();
        }
        return (ProjectCrapBean)this.crap.get();
    }

    private void loadCrap() {
        try {
            this.crap = new WeakReference<ProjectCrapBean>((ProjectCrapBean)this.getDataFile().read());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load " + this.getDataFile(), e);
        }
    }

    public String getSummary() {
        return this.buildSummary();
    }

    public String getDetails() {
        return this.buildDetails();
    }

    public String getDisplayName() {
        return "Crap Report";
    }

    @Override
    public String getTitle() {
        return "All Crappy Methods for <a href=\"" + Hudson.getInstance().getRootUrlFromRequest() + this.getOwner().getUrl() + "\">" + this.getOwner().getDisplayName() + "</a>";
    }

    @Override
    public Collection<IMethodCrap> getMethods() {
        ArrayList<IMethodCrap> result = new ArrayList<IMethodCrap>();
        Collections.addAll(result, this.getResultData().getCrapMethods());
        Collections.sort(result, new DecreasingCrapLoadComparator());
        return result;
    }

    private String buildListEntry(String url, int count, String denotation) {
        StringBuilder result = new StringBuilder();
        result.append("<li><a href=\"");
        result.append(url);
        result.append("\">");
        result.append(count);
        result.append(" ");
        result.append(denotation);
        result.append("</a></li>");
        return result.toString();
    }

    public boolean hasNewCrappyMethods() {
        return this.getResultData().getNewCrapMethodsCount() > 0;
    }

    public boolean hasFixedCrappyMethods() {
        return this.getResultData().getFixedCrapMethodsCount() > 0;
    }

    public boolean hasChangesAtCrappyMethods() {
        return this.hasNewCrappyMethods() || this.hasFixedCrappyMethods();
    }

    private String buildDetails() {
        StringBuilder result = new StringBuilder();
        if (this.hasNewCrappyMethods()) {
            result.append(this.buildListEntry("crapResult/new", this.getResultData().getNewCrapMethodsCount(), "new crap methods"));
        }
        if (this.hasFixedCrappyMethods()) {
            result.append(this.buildListEntry("crapResult/fixed", this.getResultData().getFixedCrapMethodsCount(), "fewer crap methods"));
        }
        return result.toString();
    }

    private String buildSummary() {
        StringBuilder result = new StringBuilder();
        result.append("Crap4J: ");
        int crapMethods = this.getResultData().getCrapMethodCount();
        if (0 == crapMethods) {
            result.append("No crappy methods in this project.");
        } else {
            result.append("<a href=\"crapResult\">");
            result.append(crapMethods);
            result.append(" crappy methods (");
            result.append(this.getResultData().getCrapMethodPercent());
            result.append("%)</a> out of ");
            result.append(this.getResultData().getMethodCount());
            result.append(" methods in this project.");
        }
        return result.toString();
    }

    public ICrapMethodPresentation getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        if ("new".equals(link)) {
            return new NewCrapMethodsResult(this.getOwner(), this.getResultData().getNewMethods(this.getPreviousCrap()));
        }
        if ("fixed".equals(link)) {
            return new FixedCrapMethodsResult(this.getOwner(), this.getResultData().getFixedMethods(this.getPreviousCrap()));
        }
        return this;
    }

    private XmlFile getDataFile() {
        return new XmlFile(new File(this.getOwner().getRootDir(), "crap.xml"));
    }

    private ProjectCrapBean getPreviousCrap() {
        CrapBuildResult previousResult = this.getPrevious();
        if (null == previousResult) {
            return null;
        }
        return previousResult.getResultData();
    }

    public CrapBuildResult getPrevious() {
        return CrapBuildResult.getPrevious(this.getOwner());
    }

    public static CrapBuildResult getPrevious(AbstractBuild<?, ?> currentBuild) {
        for (AbstractBuild previous = (AbstractBuild)currentBuild.getPreviousBuild(); null != previous; previous = (AbstractBuild)previous.getPreviousBuild()) {
            Crap4JBuildAction action = (Crap4JBuildAction)previous.getAction(Crap4JBuildAction.class);
            if (null == action) continue;
            return action.getResult();
        }
        return null;
    }

    static {
        XSTREAM.alias("crap", ProjectCrapBean.class);
    }
}

