/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.createjobadvanced;

import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.listeners.ItemListener;
import hudson.security.AuthorizationMatrixProperty;
import hudson.security.Permission;
import hudson.security.SecurityMode;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class CreateJobAdvanced
extends ItemListener {
    static Logger log = Logger.getLogger(CreateJobAdvanced.class.getName());

    @DataBoundConstructor
    public CreateJobAdvanced() {
        log.info("Create job advanced started");
    }

    public void onCreated(Item item) {
        if (!(item instanceof Job)) {
            return;
        }
        if (Hudson.getInstance().getSecurity().equals((Object)SecurityMode.UNSECURED)) {
            return;
        }
        Job job = (Job)item;
        AuthorizationMatrixProperty auth = (AuthorizationMatrixProperty)job.getProperty(AuthorizationMatrixProperty.class);
        if (auth == null) {
            auth = new AuthorizationMatrixProperty();
        }
        auth.setUseProjectSecurity(true);
        String sid = Hudson.getAuthentication().getName();
        try {
            Method add = auth.getClass().getDeclaredMethod("add", Permission.class, String.class);
            add.setAccessible(true);
            add.invoke((Object)auth, Item.CONFIGURE, sid);
            add.invoke((Object)auth, Item.READ, sid);
            add.invoke((Object)auth, Item.BUILD, sid);
            add.invoke((Object)auth, Item.WORKSPACE, sid);
            add.invoke((Object)auth, Item.DELETE, sid);
            job.addProperty((JobProperty)auth);
            log.info("Create Job " + item.getDisplayName() + " with right on " + sid);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "problem to set right to owner", e);
        }
        catch (NoSuchMethodException e) {
            log.log(Level.SEVERE, "can't modify add method from protected to public", e);
        }
        catch (IllegalArgumentException e) {
            log.log(Level.SEVERE, "can't modify add method from protected to public", e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, "can't modify add method from protected to public", e);
        }
        catch (InvocationTargetException e) {
            log.log(Level.SEVERE, "can't modify add method from protected to public", e);
        }
    }
}

