/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.createjobadvanced;

import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.listeners.ItemListener;
import hudson.security.AuthorizationMatrixProperty;
import hudson.security.Permission;
import hudson.security.SecurityMode;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateJobAdvanced
extends ItemListener {
    static Logger log = Logger.getLogger(CreateJobAdvanced.class.getName());

    @DataBoundConstructor
    public CreateJobAdvanced() {
        log.info("Create job advanced started");
    }

    public void onCreated(Item item) {
        if (!(item instanceof Job)) {
            return;
        }
        if (Hudson.getInstance().getSecurity().equals((Object)SecurityMode.UNSECURED)) {
            return;
        }
        Job job = (Job)item;
        HashMap<Permission, Set<String>> permissions = null;
        AuthorizationMatrixProperty auth = (AuthorizationMatrixProperty)job.getProperty(AuthorizationMatrixProperty.class);
        if (auth != null) {
            permissions = new HashMap(auth.getGrantedPermissions());
            try {
                job.removeProperty(AuthorizationMatrixProperty.class);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "problem to remove granted permissions (template or copy job)", e);
            }
        } else {
            permissions = new HashMap<Permission, Set<String>>();
        }
        String sid = Hudson.getAuthentication().getName();
        this.configurePermission(permissions, Item.CONFIGURE, sid);
        this.configurePermission(permissions, Item.READ, sid);
        this.configurePermission(permissions, Item.BUILD, sid);
        this.configurePermission(permissions, Item.WORKSPACE, sid);
        this.configurePermission(permissions, Item.DELETE, sid);
        try {
            AuthorizationMatrixProperty authProperty = new AuthorizationMatrixProperty(permissions);
            job.addProperty((JobProperty)authProperty);
            log.info("Create Job " + item.getDisplayName() + " with right on " + sid);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "problem to add granted permissions", e);
        }
    }

    private void configurePermission(Map<Permission, Set<String>> permissions, Permission permission, String sid) {
        Set<String> sidPermission = permissions.get(permission);
        if (sidPermission == null) {
            HashSet<String> sidSet = new HashSet<String>();
            sidSet.add(sid);
            permissions.put(permission, sidSet);
        } else if (!sidPermission.contains(sid)) {
            sidPermission.add(sid);
        }
    }
}

