/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.createjobadvanced;

import hudson.Plugin;
import hudson.Util;
import hudson.model.Descriptor;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class CreateJobAdvancedPlugin
extends Plugin {
    static Logger log = Logger.getLogger(CreateJobAdvancedPlugin.class.getName());
    private boolean autoOwnerRights;
    private boolean replaceSpace;
    private boolean activeLogRotator;
    private int daysToKeep = -1;
    private int numToKeep = -1;
    private int artifactDaysToKeep = -1;
    private int artifactNumToKeep = -1;

    public void start() throws Exception {
        super.start();
        log.info("Create job advanced plugin started ...");
        this.load();
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        this.autoOwnerRights = req.getParameter("cja.security") != null && req.getParameter("cja.security") != "false";
        this.replaceSpace = req.getParameter("cja.jobspacesinname") != null && req.getParameter("cja.jobspacesinname") != "false";
        this.activeLogRotator = req.getParameter("cja.activeLogRotator") != null && req.getParameter("cja.activeLogRotator") != "false";
        if (this.activeLogRotator) {
            try {
                this.daysToKeep = Integer.valueOf(Util.fixNull((String)req.getParameter("cja.daysToKeep")));
            }
            catch (Exception e) {
                this.daysToKeep = -1;
            }
            try {
                this.numToKeep = Integer.valueOf(Util.fixNull((String)req.getParameter("cja.numToKeep")));
            }
            catch (Exception e) {
                this.numToKeep = -1;
            }
            try {
                this.artifactDaysToKeep = Integer.valueOf(Util.fixNull((String)req.getParameter("cja.artifactDaysToKeep")));
            }
            catch (Exception e) {
                this.artifactDaysToKeep = -1;
            }
            try {
                this.artifactNumToKeep = Integer.valueOf(Util.fixNull((String)req.getParameter("cja.artifactNumToKeep")));
            }
            catch (Exception e) {
                this.artifactNumToKeep = -1;
            }
        }
        this.save();
    }

    public boolean isAutoOwnerRights() {
        return this.autoOwnerRights;
    }

    public boolean isReplaceSpace() {
        return this.replaceSpace;
    }

    public boolean isActiveLogRotator() {
        return this.activeLogRotator;
    }

    public int getDaysToKeep() {
        return this.daysToKeep;
    }

    public int getNumToKeep() {
        return this.numToKeep;
    }

    public int getArtifactDaysToKeep() {
        return this.artifactDaysToKeep;
    }

    public int getArtifactNumToKeep() {
        return this.artifactNumToKeep;
    }
}

