/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.createjobadvanced;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.listeners.ItemListener;
import hudson.plugins.createjobadvanced.CreateJobAdvancedPlugin;
import hudson.security.AuthorizationMatrixProperty;
import hudson.security.Permission;
import hudson.security.SecurityMode;
import hudson.tasks.LogRotator;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class ItemListenerImpl
extends ItemListener {
    static Logger log = Logger.getLogger(CreateJobAdvancedPlugin.class.getName());

    @DataBoundConstructor
    public ItemListenerImpl() {
    }

    public void onRenamed(Item item, String oldName, String newName) {
        log.info("renamed " + oldName + " to " + newName);
        if (!(item instanceof Job)) {
            return;
        }
        Job job = (Job)item;
        CreateJobAdvancedPlugin cja = (CreateJobAdvancedPlugin)Hudson.getInstance().getPlugin(CreateJobAdvancedPlugin.class);
        if (cja.isReplaceSpace()) {
            this.renameJob(job);
        }
    }

    public void onCreated(Item item) {
        if (!(item instanceof Job)) {
            return;
        }
        Job job = (Job)item;
        CreateJobAdvancedPlugin cja = (CreateJobAdvancedPlugin)Hudson.getInstance().getPlugin(CreateJobAdvancedPlugin.class);
        if (cja.isReplaceSpace()) {
            this.renameJob(job);
        }
        if (!Hudson.getInstance().getSecurity().equals((Object)SecurityMode.UNSECURED)) {
            if (cja.isAutoOwnerRights()) {
                String sid = Hudson.getAuthentication().getName();
                this.securityGrantPermissions(job, sid, Item.CONFIGURE, Item.BUILD, Item.READ, Item.DELETE, Item.WORKSPACE);
            }
            if (cja.isAutoPublicBrowse()) {
                this.securityGrantPermissions(job, "anonymous", Item.READ, Item.WORKSPACE);
            }
        }
        if (cja.isActiveLogRotator()) {
            this.activateLogRotator(job, cja);
        }
    }

    private void activateLogRotator(Job job, CreateJobAdvancedPlugin cja) {
        if (job.getLogRotator() != null) {
            return;
        }
        LogRotator logrotator = new LogRotator(cja.getDaysToKeep(), cja.getNumToKeep(), cja.getArtifactDaysToKeep(), cja.getArtifactNumToKeep());
        job.setLogRotator(logrotator);
    }

    private void renameJob(Job job) {
        if (job.getName().indexOf(" ") != -1) {
            try {
                job.renameTo(job.getName().replaceAll(" ", "-"));
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "error during rename", e);
            }
        }
    }

    private void securityGrantPermissions(Job job, String sid, Permission ... hudsonPermissions) {
        Map<Permission, Set<String>> permissions = this.initPermissions(job);
        for (Permission perm : hudsonPermissions) {
            this.configurePermission(permissions, perm, sid);
        }
        try {
            AuthorizationMatrixProperty authProperty = new AuthorizationMatrixProperty(permissions);
            job.addProperty((JobProperty)authProperty);
            log.info("Granding rights to [" + sid + "] for newly-created job " + job.getDisplayName());
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "problem to add granted permissions", e);
        }
    }

    private Map<Permission, Set<String>> initPermissions(Job job) {
        HashMap<Permission, Set<String>> permissions = null;
        AuthorizationMatrixProperty auth = (AuthorizationMatrixProperty)job.getProperty(AuthorizationMatrixProperty.class);
        if (auth != null) {
            permissions = new HashMap(auth.getGrantedPermissions());
            try {
                job.removeProperty(AuthorizationMatrixProperty.class);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "problem to remove granted permissions (template or copy job)", e);
            }
        } else {
            permissions = new HashMap<Permission, Set<String>>();
        }
        return permissions;
    }

    private void configurePermission(Map<Permission, Set<String>> permissions, Permission permission, String sid) {
        Set<String> sidPermission = permissions.get(permission);
        if (sidPermission == null) {
            HashSet<String> sidSet = new HashSet<String>();
            sidSet.add(sid);
            permissions.put(permission, sidSet);
        } else if (!sidPermission.contains(sid)) {
            sidPermission.add(sid);
        }
    }
}

