/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.createjobadvanced;

import hudson.security.Permission;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicPermissionConfig {
    private String groupFormat;
    private Set<String> checkedPermissionIds = new HashSet();

    @DataBoundConstructor
    public DynamicPermissionConfig(String groupFormat, Set<String> checkedPermissionIds) {
        this.groupFormat = groupFormat;
        if (checkedPermissionIds != null) {
            this.checkedPermissionIds = checkedPermissionIds;
        }
    }

    public void addPermissionId(String permissionId) {
        this.checkedPermissionIds.add(permissionId);
    }

    public String getGroupFormat() {
        return this.groupFormat;
    }

    public Set<String> getCheckedPermissionIds() {
        return this.checkedPermissionIds;
    }

    public boolean isPermissionChecked(Permission permission) {
        return this.checkedPermissionIds.contains(permission.getId());
    }

    public String toString() {
        return "[DynamicPermissionConfig: " + this.groupFormat + ", permissions: " + this.checkedPermissionIds + "]";
    }
}

