/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Job;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import hudson.views.ListViewColumn;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CronViewColumn
extends ListViewColumn {
    private static final String CRON_EXPRESSION_COMMENT_START = "#";
    private static final String CRON_EXPRESSION_COMMENT_COLOR = "#4a7b4a";
    @Extension
    public static final Descriptor<ListViewColumn> DESCRIPTOR = new /* Unavailable Anonymous Inner Class!! */;

    public String getCronTrigger(Job job) {
        if (!(job instanceof FreeStyleProject)) {
            return "";
        }
        StringBuilder expression = new StringBuilder();
        FreeStyleProject freeStyleProjectJob = (FreeStyleProject)job;
        SCM sourceCodeManagement = freeStyleProjectJob.getScm();
        boolean hasSourceCodeManagement = sourceCodeManagement != null && !(sourceCodeManagement instanceof NullSCM);
        Map triggers = freeStyleProjectJob.getTriggers();
        for (Trigger trigger : triggers.values()) {
            String cronExpression;
            if (trigger == null || (cronExpression = trigger.getSpec()) == null || cronExpression.trim().length() == 0) continue;
            cronExpression = this.formatComments(cronExpression);
            if (expression.length() > 0) {
                expression.append("\n<br/>\n");
            }
            if (!hasSourceCodeManagement && trigger instanceof SCMTrigger) {
                expression.append("<i>(Disabled) </i>");
            }
            expression.append(this.getTriggerName(trigger)).append(": ").append(cronExpression);
        }
        return expression.toString();
    }

    private String formatComments(String cronExpression) {
        String[] expressionLines;
        if (!cronExpression.contains(CRON_EXPRESSION_COMMENT_START)) {
            return cronExpression;
        }
        StringBuilder formattedExpression = new StringBuilder();
        for (String expressionLine : expressionLines = cronExpression.split("\n")) {
            int commentStartIndex = expressionLine.indexOf(CRON_EXPRESSION_COMMENT_START);
            if (commentStartIndex < 0) {
                formattedExpression.append(expressionLine);
            } else {
                formattedExpression.append(expressionLine.substring(0, commentStartIndex));
                formattedExpression.append("<b><i><font color=\"#4a7b4a\">");
                formattedExpression.append(expressionLine.substring(commentStartIndex));
                formattedExpression.append("</font></i></b>");
            }
            formattedExpression.append(" ");
        }
        return formattedExpression.toString().trim();
    }

    private String getTriggerName(Trigger<?> trigger) {
        String type = trigger.getDescriptor().getDisplayName();
        if (type == null || type.trim().length() == 0) {
            type = trigger instanceof SCMTrigger ? "SCM polling" : (trigger instanceof TimerTrigger ? "Build Trigger" : "Unknown Type");
        }
        return type;
    }

    public Descriptor<ListViewColumn> getDescriptor() {
        return DESCRIPTOR;
    }
}

