/*
 * Decompiled with CFR 0.152.
 */
package de.theit.hudson.crowd;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.CrowdClient;
import de.theit.hudson.crowd.ErrorMessages;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrowdConfigurationService {
    private static final Logger LOG = Logger.getLogger(CrowdConfigurationService.class.getName());
    private static final int MAX_GROUPS = 500;
    ClientProperties clientProperties;
    CrowdClient crowdClient;
    CrowdHttpTokenHelper tokenHelper;
    CrowdHttpAuthenticator crowdHttpAuthenticator;
    String groupName;
    private boolean nestedGroups;

    public CrowdConfigurationService(String pGroupName, boolean pNestedGroups) {
        this.groupName = pGroupName.trim();
        if (0 == this.groupName.length()) {
            throw new IllegalArgumentException(ErrorMessages.specifyGroup());
        }
        this.nestedGroups = pNestedGroups;
    }

    public boolean isGroupMember(String username) {
        boolean retval = false;
        try {
            if (this.crowdClient.isUserDirectGroupMember(username, this.groupName)) {
                retval = true;
            } else if (this.nestedGroups && this.crowdClient.isUserNestedGroupMember(username, this.groupName)) {
                retval = true;
            }
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
        }
        return retval;
    }

    public boolean isGroupActive() {
        boolean retval = false;
        try {
            Group group = this.crowdClient.getGroup(this.groupName);
            if (null != group) {
                retval = group.isActive();
            }
        }
        catch (GroupNotFoundException ex) {
            LOG.info(ErrorMessages.groupNotFound((String)this.groupName));
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
        }
        return retval;
    }

    public Collection<GrantedAuthority> getAuthoritiesForUser(String username) {
        List groups;
        int index;
        TreeSet<GrantedAuthority> authorities = new TreeSet<GrantedAuthority>((Comparator<GrantedAuthority>)new /* Unavailable Anonymous Inner Class!! */);
        HashSet<String> groupNames = new HashSet<String>();
        try {
            index = 0;
            LOG.fine("Retrieve list of groups with direct membership for user '" + username + "'...");
            while (true) {
                LOG.finest("Fetching groups [" + index + "..." + (index + 500 - 1) + "]...");
                groups = this.crowdClient.getGroupsForUser(username, index, 500);
                if (null != groups && !groups.isEmpty()) {
                    for (Group group : groups) {
                        if (!group.isActive()) continue;
                        groupNames.add(group.getName());
                    }
                    index += 500;
                    continue;
                }
                break;
            }
        }
        catch (UserNotFoundException ex) {
            LOG.info(ErrorMessages.userNotFound((String)username));
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
        }
        if (this.nestedGroups) {
            try {
                index = 0;
                LOG.fine("Retrieve list of groups with direct membership for user '" + username + "'...");
                while (true) {
                    LOG.finest("Fetching groups [" + index + "..." + (index + 500 - 1) + "]...");
                    groups = this.crowdClient.getGroupsForNestedUser(username, index, 500);
                    if (null != groups && !groups.isEmpty()) {
                        for (Group group : groups) {
                            if (!group.isActive()) continue;
                            groupNames.add(group.getName());
                        }
                        index += 500;
                        continue;
                    }
                    break;
                }
            }
            catch (UserNotFoundException ex) {
                LOG.info(ErrorMessages.userNotFound((String)username));
            }
            catch (InvalidAuthenticationException ex) {
                LOG.warning(ErrorMessages.invalidAuthentication());
            }
            catch (ApplicationPermissionException ex) {
                LOG.warning(ErrorMessages.applicationPermission());
            }
            catch (OperationFailedException ex) {
                LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
            }
        }
        for (String str : groupNames) {
            authorities.add((GrantedAuthority)new GrantedAuthorityImpl(str));
        }
        return authorities;
    }
}

