/*
 * Decompiled with CFR 0.152.
 */
package de.theit.hudson.crowd;

import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.user.User;
import de.theit.hudson.crowd.CrowdAuthenticationToken;
import de.theit.hudson.crowd.CrowdConfigurationService;
import de.theit.hudson.crowd.ErrorMessages;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.ui.rememberme.RememberMeServices;

public class CrowdRememberMeServices
implements RememberMeServices {
    private static final Logger LOG = Logger.getLogger(CrowdRememberMeServices.class.getName());
    private CrowdConfigurationService configuration;

    public CrowdRememberMeServices(CrowdConfigurationService pConfiguration) {
        this.configuration = pConfiguration;
    }

    public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
        CrowdAuthenticationToken result = null;
        List validationFactors = this.configuration.tokenHelper.getValidationFactorExtractor().getValidationFactors(request);
        String ssoToken = this.configuration.tokenHelper.getCrowdToken(request, this.configuration.clientProperties.getCookieTokenKey());
        if (null != ssoToken) {
            try {
                this.configuration.crowdClient.validateSSOAuthentication(ssoToken, validationFactors);
                User user = this.configuration.crowdClient.findUserFromSSOToken(ssoToken);
                if (this.configuration.isGroupActive() && this.configuration.isGroupMember(user.getName())) {
                    ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
                    authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
                    authorities.addAll(this.configuration.getAuthoritiesForUser(user.getName()));
                    result = new CrowdAuthenticationToken(user.getName(), null, authorities, ssoToken, user.getDisplayName());
                }
            }
            catch (InvalidTokenException ex) {
            }
            catch (ApplicationPermissionException ex) {
                LOG.warning(ErrorMessages.applicationPermission());
            }
            catch (InvalidAuthenticationException ex) {
                LOG.warning(ErrorMessages.invalidAuthentication());
            }
            catch (OperationFailedException ex) {
                LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
            }
        }
        return result;
    }

    public void loginFail(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.configuration.crowdHttpAuthenticator.logout(request, response);
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
        }
    }

    public void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        if (!(successfulAuthentication instanceof CrowdAuthenticationToken)) {
            return;
        }
        CrowdAuthenticationToken crowdAuthenticationToken = (CrowdAuthenticationToken)successfulAuthentication;
        List validationFactors = this.configuration.tokenHelper.getValidationFactorExtractor().getValidationFactors(request);
        String ssoToken = crowdAuthenticationToken.getSSOToken();
        try {
            if (null == ssoToken) {
                this.configuration.crowdHttpAuthenticator.authenticate(request, response, crowdAuthenticationToken.getPrincipal(), crowdAuthenticationToken.getCredentials());
                ssoToken = this.configuration.tokenHelper.getCrowdToken(request, this.configuration.clientProperties.getCookieTokenKey());
            }
            if (null == ssoToken) {
                this.loginFail(request, response);
                return;
            }
            this.configuration.crowdClient.validateSSOAuthentication(ssoToken, validationFactors);
        }
        catch (InvalidTokenException ex) {
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
        }
        catch (ExpiredCredentialException ex) {
            LOG.warning(ErrorMessages.expiredCredentials((String)crowdAuthenticationToken.getPrincipal()));
        }
        catch (InactiveAccountException ex) {
            LOG.warning(ErrorMessages.accountExpired((String)crowdAuthenticationToken.getPrincipal()));
        }
        catch (ApplicationAccessDeniedException ex) {
            LOG.warning(ErrorMessages.applicationAccessDenied((String)crowdAuthenticationToken.getPrincipal()));
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.configuration.crowdHttpAuthenticator.logout(request, response);
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
        }
    }
}

