/*
 * Decompiled with CFR 0.152.
 */
package de.theit.hudson.crowd;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.User;
import de.theit.hudson.crowd.CrowdConfigurationService;
import de.theit.hudson.crowd.CrowdUser;
import de.theit.hudson.crowd.ErrorMessages;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class CrowdUserDetailsService
implements UserDetailsService {
    private static final Logger LOG = Logger.getLogger(CrowdUserDetailsService.class.getName());
    private CrowdConfigurationService configuration;

    public CrowdUserDetailsService(CrowdConfigurationService pConfiguration) {
        this.configuration = pConfiguration;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        User user;
        if (!this.configuration.isGroupActive()) {
            throw new DataRetrievalFailureException(ErrorMessages.userGroupNotFound((String)this.configuration.groupName));
        }
        if (!this.configuration.isGroupMember(username)) {
            throw new DataRetrievalFailureException(ErrorMessages.userNotValid((String)username, (String)this.configuration.groupName));
        }
        try {
            user = this.configuration.crowdClient.getUser(username);
        }
        catch (UserNotFoundException ex) {
            LOG.info(ErrorMessages.userNotFound((String)username));
            throw new UsernameNotFoundException(ErrorMessages.userNotFound((String)username), (Throwable)ex);
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
            throw new DataRetrievalFailureException(ErrorMessages.applicationPermission(), (Throwable)ex);
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
            throw new DataRetrievalFailureException(ErrorMessages.invalidAuthentication(), (Throwable)ex);
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
            throw new DataRetrievalFailureException(ErrorMessages.operationFailed(), (Throwable)ex);
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        authorities.addAll(this.configuration.getAuthoritiesForUser(username));
        return new CrowdUser(user, authorities);
    }
}

