/*
 * Decompiled with CFR 0.152.
 */
package de.theit.hudson.crowd;

import de.theit.hudson.crowd.CrowdSecurityRealm;
import de.theit.hudson.crowd.CrowdUser;
import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.security.SecurityRealm;
import hudson.tasks.MailAddressResolver;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.dao.DataAccessException;

@Extension
public class CrowdMailAddressResolverImpl
extends MailAddressResolver {
    private static final Logger LOG = Logger.getLogger(CrowdMailAddressResolverImpl.class.getName());

    public String findMailAddressFor(User u) {
        String mail = null;
        SecurityRealm realm = Hudson.getInstance().getSecurityRealm();
        if (realm instanceof CrowdSecurityRealm) {
            try {
                CrowdUser details = (CrowdUser)realm.getSecurityComponents().userDetails.loadUserByUsername(u.getId());
                mail = details.getEmailAddress();
            }
            catch (UsernameNotFoundException ex) {
                LOG.info("Failed to look up email address in Crowd");
            }
            catch (DataAccessException ex) {
                LOG.log(Level.SEVERE, "Access exception trying to look up email address in Crowd", ex);
            }
        }
        return mail;
    }
}

