/*
 * Decompiled with CFR 0.152.
 */
package de.theit.hudson.crowd;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticatorImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelperImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractor;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractorImpl;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import de.theit.hudson.crowd.CrowdAuthenticationManager;
import de.theit.hudson.crowd.CrowdConfigurationService;
import de.theit.hudson.crowd.CrowdRememberMeServices;
import de.theit.hudson.crowd.CrowdServletFilter;
import de.theit.hudson.crowd.CrowdUser;
import de.theit.hudson.crowd.CrowdUserDetailsService;
import de.theit.hudson.crowd.ErrorMessages;
import hudson.model.Hudson;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AccountExpiredException;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.InsufficientAuthenticationException;
import org.acegisecurity.ui.rememberme.RememberMeServices;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class CrowdSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    private static final Logger LOG = Logger.getLogger(CrowdSecurityRealm.class.getName());
    public final String url;
    public final String applicationName;
    public final String password;
    public final String group;
    public final boolean nestedGroups;
    private transient CrowdConfigurationService configuration;

    @DataBoundConstructor
    public CrowdSecurityRealm(String url, String applicationName, String password, String group, boolean nestedGroups) {
        this.url = url.trim();
        this.applicationName = applicationName.trim();
        this.password = password.trim();
        this.group = group.trim();
        this.nestedGroups = nestedGroups;
    }

    private void initializeConfiguration() {
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream("/crowd.properties"));
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.cannotLoadCrowdProperties(), ex);
        }
        if (this.applicationName != null || this.password != null || this.url != null) {
            String crowdUrl = this.url;
            if (!crowdUrl.endsWith("/")) {
                crowdUrl = crowdUrl + "/";
            }
            props.setProperty("application.name", this.applicationName);
            props.setProperty("application.password", this.password);
            props.setProperty("crowd.base.url", crowdUrl);
            props.setProperty("application.login.url", crowdUrl + "console/");
            props.setProperty("crowd.server.url", this.url + "services/");
            props.setProperty("session.validationinterval", "5");
        } else {
            LOG.warning("Client properties are incomplete");
        }
        this.configuration = new CrowdConfigurationService(this.group, this.nestedGroups);
        this.configuration.clientProperties = ClientPropertiesImpl.newInstanceFromProperties((Properties)props);
        this.configuration.crowdClient = new RestCrowdClientFactory().newInstance(this.configuration.clientProperties);
        this.configuration.tokenHelper = CrowdHttpTokenHelperImpl.getInstance((CrowdHttpValidationFactorExtractor)CrowdHttpValidationFactorExtractorImpl.getInstance());
        this.configuration.crowdHttpAuthenticator = new CrowdHttpAuthenticatorImpl(this.configuration.crowdClient, this.configuration.clientProperties, this.configuration.tokenHelper);
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        if (null == this.configuration) {
            this.initializeConfiguration();
        }
        CrowdRememberMeServices ssoService = new CrowdRememberMeServices(this.configuration);
        CrowdAuthenticationManager crowdAuthenticationManager = new CrowdAuthenticationManager(this.configuration);
        CrowdUserDetailsService crowdUserDetails = new CrowdUserDetailsService(this.configuration);
        return new SecurityRealm.SecurityComponents((AuthenticationManager)crowdAuthenticationManager, (UserDetailsService)crowdUserDetails, (RememberMeServices)ssoService);
    }

    public void doLogout(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        SecurityRealm realm = Hudson.getInstance().getSecurityRealm();
        if (realm instanceof CrowdSecurityRealm && realm.getSecurityComponents().rememberMe instanceof CrowdRememberMeServices) {
            ((CrowdRememberMeServices)realm.getSecurityComponents().rememberMe).logout((HttpServletRequest)req, (HttpServletResponse)rsp);
        }
        super.doLogout(req, rsp);
    }

    public Filter createFilter(FilterConfig filterConfig) {
        if (null == this.configuration) {
            this.initializeConfiguration();
        }
        Filter defaultFilter = super.createFilter(filterConfig);
        return new CrowdServletFilter(this, this.configuration, defaultFilter);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.getSecurityComponents().userDetails.loadUserByUsername(username);
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        try {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Trying to load group: " + groupname);
            }
            Group crowdGroup = this.configuration.crowdClient.getGroup(groupname);
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        catch (GroupNotFoundException ex) {
            LOG.info(ErrorMessages.groupNotFound((String)groupname));
            throw new DataRetrievalFailureException(ErrorMessages.groupNotFound((String)groupname), (Throwable)ex);
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
            throw new DataRetrievalFailureException(ErrorMessages.applicationPermission(), (Throwable)ex);
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
            throw new DataRetrievalFailureException(ErrorMessages.invalidAuthentication(), (Throwable)ex);
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
            throw new DataRetrievalFailureException(ErrorMessages.operationFailed(), (Throwable)ex);
        }
    }

    protected UserDetails authenticate(String pUsername, String pPassword) throws AuthenticationException {
        User user;
        if (!this.configuration.isGroupActive()) {
            throw new InsufficientAuthenticationException(ErrorMessages.userGroupNotFound((String)this.configuration.groupName));
        }
        if (!this.configuration.isGroupMember(pUsername)) {
            throw new InsufficientAuthenticationException(ErrorMessages.userNotValid((String)pUsername, (String)this.configuration.groupName));
        }
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Authenticate user '" + pUsername + "' using password '" + (null != pPassword ? "<available>'" : "<not specified>'"));
            }
            user = this.configuration.crowdClient.authenticateUser(pUsername, pPassword);
        }
        catch (UserNotFoundException ex) {
            LOG.info(ErrorMessages.userNotFound((String)pUsername));
            throw new BadCredentialsException(ErrorMessages.userNotFound((String)pUsername), (Throwable)ex);
        }
        catch (ExpiredCredentialException ex) {
            LOG.warning(ErrorMessages.expiredCredentials((String)pUsername));
            throw new BadCredentialsException(ErrorMessages.expiredCredentials((String)pUsername), (Throwable)ex);
        }
        catch (InactiveAccountException ex) {
            LOG.warning(ErrorMessages.accountExpired((String)pUsername));
            throw new AccountExpiredException(ErrorMessages.accountExpired((String)pUsername), (Throwable)ex);
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
            throw new AuthenticationServiceException(ErrorMessages.applicationPermission(), (Throwable)ex);
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
            throw new AuthenticationServiceException(ErrorMessages.invalidAuthentication(), (Throwable)ex);
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
            throw new AuthenticationServiceException(ErrorMessages.operationFailed(), (Throwable)ex);
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        authorities.addAll(this.configuration.getAuthoritiesForUser(pUsername));
        return new CrowdUser(user, authorities);
    }
}

