/*
 * Decompiled with CFR 0.152.
 */
package de.theit.hudson.crowd;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import de.theit.hudson.crowd.CrowdAuthenticationToken;
import de.theit.hudson.crowd.CrowdConfigurationService;
import de.theit.hudson.crowd.ErrorMessages;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.AccountExpiredException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.CredentialsExpiredException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.InsufficientAuthenticationException;

public class CrowdAuthenticationManager
implements AuthenticationManager {
    private static final Logger LOG = Logger.getLogger(CrowdAuthenticationManager.class.getName());
    private CrowdConfigurationService configuration;

    public CrowdAuthenticationManager(CrowdConfigurationService pConfiguration) {
        this.configuration = pConfiguration;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getPrincipal().toString();
        if (null == authentication.getCredentials() && authentication instanceof CrowdAuthenticationToken && null != ((CrowdAuthenticationToken)authentication).getSSOToken()) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("User '" + username + "' already authenticated");
            }
            return authentication;
        }
        String password = authentication.getCredentials().toString();
        if (!this.configuration.isGroupActive()) {
            throw new InsufficientAuthenticationException(ErrorMessages.userGroupNotFound(username));
        }
        if (!this.configuration.isGroupMember(username)) {
            throw new InsufficientAuthenticationException(ErrorMessages.userNotValid(username, this.configuration.groupName));
        }
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Authenticating user: " + username);
            }
            this.configuration.crowdClient.authenticateUser(username, password);
        }
        catch (UserNotFoundException ex) {
            LOG.info(ErrorMessages.userNotFound(username));
            throw new BadCredentialsException(ErrorMessages.userNotFound(username), (Throwable)ex);
        }
        catch (ExpiredCredentialException ex) {
            LOG.warning(ErrorMessages.expiredCredentials(username));
            throw new CredentialsExpiredException(ErrorMessages.expiredCredentials(username), (Throwable)ex);
        }
        catch (InactiveAccountException ex) {
            LOG.warning(ErrorMessages.accountExpired(username));
            throw new AccountExpiredException(ErrorMessages.accountExpired(username), (Throwable)ex);
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
            throw new AuthenticationServiceException(ErrorMessages.applicationPermission(), (Throwable)ex);
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
            throw new AuthenticationServiceException(ErrorMessages.invalidAuthentication(), (Throwable)ex);
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
            throw new AuthenticationServiceException(ErrorMessages.operationFailed(), (Throwable)ex);
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        authorities.addAll(this.configuration.getAuthoritiesForUser(username));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("User successfully authenticated; creating authentication token");
        }
        return new CrowdAuthenticationToken(username, password, authorities);
    }
}

