/*
 * Decompiled with CFR 0.152.
 */
package de.theit.hudson.crowd;

import com.atlassian.crowd.exception.OperationFailedException;
import de.theit.hudson.crowd.CrowdAuthenticationToken;
import de.theit.hudson.crowd.CrowdConfigurationService;
import de.theit.hudson.crowd.CrowdRememberMeServices;
import de.theit.hudson.crowd.CrowdSecurityRealm;
import de.theit.hudson.crowd.ErrorMessages;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;

public class CrowdServletFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(CrowdServletFilter.class.getName());
    private CrowdConfigurationService configuration;
    private Filter defaultFilter;
    private CrowdSecurityRealm securityRealm;
    private CrowdRememberMeServices rememberMe;

    public CrowdServletFilter(CrowdSecurityRealm pSecurityRealm, CrowdConfigurationService pConfiguration, Filter pDefaultFilter) {
        this.securityRealm = pSecurityRealm;
        this.configuration = pConfiguration;
        this.defaultFilter = pDefaultFilter;
        if (this.securityRealm.getSecurityComponents().rememberMe instanceof CrowdRememberMeServices) {
            this.rememberMe = (CrowdRememberMeServices)this.securityRealm.getSecurityComponents().rememberMe;
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.defaultFilter.init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            boolean isValidated = false;
            try {
                isValidated = this.configuration.crowdHttpAuthenticator.isAuthenticated(req, res);
            }
            catch (OperationFailedException ex) {
                LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
            }
            if (!isValidated) {
                HttpSession session;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("User is not logged in (anymore) via Crowd => logout user");
                }
                SecurityContext sc = SecurityContextHolder.getContext();
                sc.setAuthentication(null);
                if (null != this.rememberMe) {
                    this.rememberMe.logout(req, res);
                }
                if ((session = req.getSession(false)) != null) {
                    session.invalidate();
                }
                SecurityContextHolder.clearContext();
                Cookie cookie = new Cookie("ACEGI_SECURITY_HASHED_REMEMBER_ME_COOKIE", "");
                cookie.setPath(req.getContextPath().length() > 0 ? req.getContextPath() : "/");
                res.addCookie(cookie);
            } else {
                SecurityContext sc = SecurityContextHolder.getContext();
                if (!(sc.getAuthentication() instanceof CrowdAuthenticationToken) && null != this.rememberMe) {
                    Authentication auth;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("User is logged in via Crowd, but no authentication token available; trying auto-login...");
                    }
                    if (null != (auth = this.rememberMe.autoLogin(req, res))) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("User sucessfully logged in");
                        }
                        sc.setAuthentication(auth);
                    }
                }
            }
        }
        this.defaultFilter.doFilter(request, response, chain);
    }

    public void destroy() {
        this.defaultFilter.destroy();
    }
}

