/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.AbstractProject;
import hudson.model.User;
import hudson.scm.CVSSCM;
import hudson.scm.SCM;
import hudson.tasks.MailAddressResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class MailAddressResolverImpl
extends MailAddressResolver {
    private static final Map<Pattern, String> RULE_TABLE = new HashMap<Pattern, String>();

    public String findMailAddressFor(User u) {
        for (AbstractProject p : u.getProjects()) {
            CVSSCM cvsscm;
            String s;
            SCM scm = p.getScm();
            if (!(scm instanceof CVSSCM) || (s = this.findMailAddressFor(u, (cvsscm = (CVSSCM)scm).getCvsRoot())) == null) continue;
            return s;
        }
        return null;
    }

    protected String findMailAddressFor(User u, String scm) {
        for (Map.Entry<Pattern, String> e : RULE_TABLE.entrySet()) {
            if (!e.getKey().matcher(scm).matches()) continue;
            return u.getId() + e.getValue();
        }
        return null;
    }

    static {
        String username = "([A-Za-z0-9_\\-])+";
        String host = "(.*.dev.java.net|kohsuke.sfbay.*)";
        Pattern cvsUrl = Pattern.compile(":pserver:" + username + "@" + host + ":/cvs");
        RULE_TABLE.put(cvsUrl, "@dev.java.net");
        Pattern cvsUrl2 = Pattern.compile(":(pserver|ext):([^@]+)@([^.]+).cvs.(sourceforge|sf).net:.+");
        RULE_TABLE.put(cvsUrl2, "@users.sourceforge.net");
    }
}

