/*
 * Decompiled with CFR 0.152.
 */
package hudson.org.apache.tools.ant.taskdefs.cvslib;

import hudson.org.apache.tools.ant.taskdefs.cvslib.CVSEntry;
import hudson.org.apache.tools.ant.taskdefs.cvslib.RCSFile;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;

class ChangeLogWriter {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final FastDateFormat c_outputDate = FastDateFormat.getInstance((String)"yyyy-MM-dd", (TimeZone)UTC);
    private static final FastDateFormat c_outputTime = FastDateFormat.getInstance((String)"HH:mm", (TimeZone)UTC);

    ChangeLogWriter() {
    }

    public void printChangeLog(PrintWriter output, CVSEntry[] entries) {
        output.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        output.println("<changelog>");
        for (int i = 0; i < entries.length; ++i) {
            CVSEntry entry = entries[i];
            this.printEntry(output, entry);
        }
        output.println("</changelog>");
        output.flush();
        output.close();
    }

    private void printEntry(PrintWriter output, CVSEntry entry) {
        output.println("\t<entry>");
        output.println("\t\t<date>" + c_outputDate.format(entry.getDate()) + "</date>");
        output.println("\t\t<time>" + c_outputTime.format(entry.getDate()) + "</time>");
        output.println("\t\t<author><![CDATA[" + entry.getAuthor() + "]]></author>");
        Enumeration enumeration = entry.getFiles().elements();
        while (enumeration.hasMoreElements()) {
            RCSFile file = (RCSFile)enumeration.nextElement();
            output.println("\t\t<file>");
            output.println("\t\t\t<name>" + file.getName() + "</name>");
            if (file.getFullName() != null) {
                output.println("\t\t\t<fullName>" + file.getFullName() + "</fullName>");
            }
            output.println("\t\t\t<revision>" + file.getRevision() + "</revision>");
            String previousRevision = file.getPreviousRevision();
            if (previousRevision != null) {
                output.println("\t\t\t<prevrevision>" + previousRevision + "</prevrevision>");
            }
            if (file.isDead()) {
                output.println("\t\t\t<dead />");
            }
            output.println("\t\t</file>");
        }
        output.println("\t\t<msg><![CDATA[" + entry.getComment() + "]]></msg>");
        output.println("\t</entry>");
    }
}

