/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.remoting.Future;
import hudson.remoting.RemoteOutputStream;
import hudson.scm.CVSChangeLogParser;
import hudson.scm.CVSRepositoryBrowser;
import hudson.scm.CVSSCM;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.cvs.Messages;
import hudson.util.ArgumentListBuilder;
import hudson.util.ForkOutputStream;
import hudson.util.IOException2;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CVSSCM
extends SCM
implements Serializable {
    private String cvsroot;
    private String module;
    private String branch;
    private String cvsRsh;
    private boolean canUseUpdate;
    private boolean flatten;
    private CVSRepositoryBrowser repositoryBrowser;
    private boolean isTag;
    private String excludedRegions;
    private static final Pattern UPDATE_LINE = Pattern.compile("[UPARMC] (.+)");
    private static final Pattern REMOVAL_LINE = Pattern.compile("cvs (server|update): `?(.+?)'? is no longer in the repository");
    private static final Pattern PSERVER_CVSROOT_WITH_PASSWORD = Pattern.compile("(:pserver:[^@:]+):[^@:]+(@.+)");
    public static boolean debug = Boolean.getBoolean(CVSSCM.class.getName() + ".debug");
    public static boolean noQuiet = Boolean.getBoolean(CVSSCM.class.getName() + ".noQuiet");
    private static final long serialVersionUID = 1L;
    public static boolean skipChangeLog = Boolean.getBoolean(CVSSCM.class.getName() + ".skipChangeLog");
    private static final Logger LOGGER = Logger.getLogger(CVSSCM.class.getName());

    @DataBoundConstructor
    public CVSSCM(String cvsRoot, String allModules, String branch, String cvsRsh, boolean canUseUpdate, boolean legacy, boolean isTag, String excludedRegions) {
        if (Util.fixNull((String)branch).equals("HEAD")) {
            branch = null;
        }
        this.cvsroot = Util.fixNull((String)cvsRoot).trim();
        this.module = allModules.trim();
        this.branch = this.nullify(branch);
        this.cvsRsh = this.nullify(cvsRsh);
        this.canUseUpdate = canUseUpdate;
        this.flatten = !legacy && this.getAllModulesNormalized().length == 1;
        this.isTag = isTag;
        this.excludedRegions = excludedRegions;
    }

    public CVSRepositoryBrowser getBrowser() {
        return this.repositoryBrowser;
    }

    private String compression() {
        if (this.getDescriptor().isNoCompression()) {
            return null;
        }
        boolean local = this.cvsroot.startsWith("/") || this.cvsroot.startsWith(":local:") || this.cvsroot.startsWith(":fork:");
        return local ? "-z0" : "-z3";
    }

    @Exported
    public String getCvsRoot() {
        return this.cvsroot;
    }

    @Exported
    public boolean isTag() {
        return this.isTag;
    }

    public FilePath getModuleRoot(FilePath workspace) {
        if (this.flatten) {
            return workspace;
        }
        return workspace.child(this.getAllModulesNormalized()[0]);
    }

    public FilePath[] getModuleRoots(FilePath workspace) {
        if (!this.flatten) {
            String[] moduleLocations = this.getAllModulesNormalized();
            FilePath[] moduleRoots = new FilePath[moduleLocations.length];
            for (int i = 0; i < moduleLocations.length; ++i) {
                moduleRoots[i] = workspace.child(moduleLocations[i]);
            }
            return moduleRoots;
        }
        return new FilePath[]{this.getModuleRoot(workspace)};
    }

    public ChangeLogParser createChangeLogParser() {
        return new CVSChangeLogParser();
    }

    @Exported
    public String getAllModules() {
        return this.module;
    }

    @Exported
    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.excludedRegions == null ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    private Pattern[] getExcludedRegionsPatterns() {
        String[] excludedRegions = this.getExcludedRegionsNormalized();
        if (excludedRegions != null) {
            Pattern[] patterns = new Pattern[excludedRegions.length];
            int i = 0;
            for (String excludedRegion : excludedRegions) {
                patterns[i++] = Pattern.compile(excludedRegion);
            }
            return patterns;
        }
        return null;
    }

    public String[] getAllModulesNormalized() {
        String[] r = this.module.split("(?<!\\\\)[ \\r\\n]+");
        for (int i = 0; i < r.length; ++i) {
            r[i] = r[i].replaceAll("\\\\ ", " ");
        }
        return r;
    }

    @Exported
    public String getBranch() {
        return this.branch;
    }

    @Exported
    public String getCvsRsh() {
        return this.cvsRsh;
    }

    @Exported
    public boolean getCanUseUpdate() {
        return this.canUseUpdate;
    }

    @Exported
    public boolean isFlatten() {
        return this.flatten;
    }

    public boolean isLegacy() {
        return !this.flatten;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath dir, TaskListener listener) throws IOException, InterruptedException {
        String why = this.isUpdatable(dir);
        if (why != null) {
            listener.getLogger().println(Messages.CVSSCM_WorkspaceInconsistent((Object)why));
            return true;
        }
        List changedFiles = this.update(true, launcher, dir, listener, new Date());
        if (changedFiles != null && !changedFiles.isEmpty()) {
            Pattern[] patterns = this.getExcludedRegionsPatterns();
            if (patterns != null) {
                boolean areThereChanges = false;
                for (String changedFile : changedFiles) {
                    boolean patternMatched = false;
                    for (Pattern pattern : patterns) {
                        if (!pattern.matcher(changedFile).matches()) continue;
                        patternMatched = true;
                        break;
                    }
                    if (patternMatched) continue;
                    areThereChanges = true;
                    break;
                }
                return areThereChanges;
            }
            return true;
        }
        return false;
    }

    private void configureDate(ArgumentListBuilder cmd, Date date) {
        if (this.isTag) {
            return;
        }
        DateFormat df = DateFormat.getDateTimeInstance(0, 0, Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        cmd.add(new String[]{"-D", df.format(date)});
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath ws, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        List changedFiles = null;
        if (this.canUseUpdate && this.isUpdatable(ws) == null ? (changedFiles = this.update(false, launcher, ws, (TaskListener)listener, build.getTimestamp().getTime())) == null : !this.checkout(launcher, ws, (TaskListener)listener, build.getTimestamp().getTime())) {
            return false;
        }
        File archiveFile = CVSSCM.getArchiveFile((AbstractBuild)build);
        RemoteOutputStream os = new RemoteOutputStream((OutputStream)new FileOutputStream(archiveFile));
        ws.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        build.getActions().add(new TagAction(this, build));
        return this.calcChangeLog(build, ws, changedFiles, changelogFile, listener);
    }

    public boolean checkout(Launcher launcher, FilePath dir, TaskListener listener) throws IOException, InterruptedException {
        Date now = new Date();
        if (this.canUseUpdate && this.isUpdatable(dir) == null) {
            return this.update(false, launcher, dir, listener, now) != null;
        }
        return this.checkout(launcher, dir, listener, now);
    }

    private boolean checkout(Launcher launcher, FilePath dir, TaskListener listener, Date dt) throws IOException, InterruptedException {
        dir.deleteContents();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(new String[]{this.getDescriptor().getCvsExeOrDefault(), noQuiet ? null : (debug ? "-t" : "-Q"), this.compression(), "-d", this.cvsroot, "co", "-P"});
        if (this.branch != null) {
            cmd.add(new String[]{"-r", this.branch});
        }
        if (this.flatten) {
            cmd.add(new String[]{"-d", dir.getName()});
        }
        this.configureDate(cmd, dt);
        cmd.add(this.getAllModulesNormalized());
        if (!this.run(launcher, cmd, listener, this.flatten ? dir.getParent() : dir)) {
            return false;
        }
        if (this.flatten) {
            dir.act((FilePath.FileCallable)new StickyDateCleanUpTask(null));
        } else {
            for (String module : this.getAllModulesNormalized()) {
                dir.child(module).act((FilePath.FileCallable)new StickyDateCleanUpTask(null));
            }
        }
        return true;
    }

    private static File getArchiveFile(AbstractBuild build) {
        return new File(build.getRootDir(), "workspace.zip");
    }

    private void archive(File dir, String relPath, ZipOutputStream zos, boolean isRoot) throws IOException {
        HashSet<String> knownFiles = new HashSet<String>();
        this.parseCVSEntries(new File(dir, "CVS/Entries"), knownFiles);
        this.parseCVSEntries(new File(dir, "CVS/Entries.Log"), knownFiles);
        this.parseCVSEntries(new File(dir, "CVS/Entries.Extra"), knownFiles);
        boolean hasCVSdirs = !knownFiles.isEmpty();
        knownFiles.add("CVS");
        File[] files = dir.listFiles();
        if (files == null) {
            if (isRoot) {
                throw new IOException("No such directory exists. Did you specify the correct branch? Perhaps you specified a tag: " + dir);
            }
            throw new IOException("No such directory exists. Looks like someone is modifying the workspace concurrently: " + dir);
        }
        for (File f : files) {
            String name = relPath + '/' + f.getName();
            if (f.isDirectory()) {
                if (hasCVSdirs && !knownFiles.contains(f.getName())) continue;
                this.archive(f, name, zos, false);
                continue;
            }
            if (!dir.getName().equals("CVS")) continue;
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream fis = new FileInputStream(f);
            Util.copyStream((InputStream)fis, (OutputStream)zos);
            fis.close();
            zos.closeEntry();
        }
    }

    private void parseCVSEntries(File entries, Set<String> knownFiles) throws IOException {
        String line;
        if (!entries.exists()) {
            return;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(entries)));
        while ((line = in.readLine()) != null) {
            String[] tokens = line.split("/+");
            if (tokens == null || tokens.length < 2) continue;
            knownFiles.add(tokens[1]);
        }
        in.close();
    }

    private List<String> update(boolean dryRun, Launcher launcher, FilePath workspace, TaskListener listener, Date date) throws IOException, InterruptedException {
        ArrayList<String> changedFileNames = new ArrayList<String>();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(new String[]{this.getDescriptor().getCvsExeOrDefault(), debug ? "-t" : "-q", this.compression()});
        if (dryRun) {
            cmd.add("-n");
        }
        cmd.add(new String[]{"update", "-PdC"});
        if (this.branch != null) {
            cmd.add(new String[]{"-r", this.branch});
        }
        this.configureDate(cmd, date);
        if (this.flatten) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (!this.run(launcher, cmd, listener, workspace, (OutputStream)new ForkOutputStream((OutputStream)baos, (OutputStream)listener.getLogger()))) {
                return null;
            }
            Future task = workspace.actAsync((FilePath.FileCallable)new StickyDateCleanUpTask(null));
            this.parseUpdateOutput("", baos, changedFileNames);
            this.join(task);
        } else {
            TreeSet<String> moduleNames = new TreeSet<String>(Arrays.asList(this.getAllModulesNormalized()));
            moduleNames.addAll((Collection)workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */));
            for (String moduleName : moduleNames) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FilePath modulePath = new FilePath(workspace, moduleName);
                ArgumentListBuilder actualCmd = cmd;
                String baseName = moduleName;
                if (!modulePath.isDirectory()) {
                    actualCmd = cmd.clone();
                    actualCmd.add(modulePath.getName());
                    modulePath = modulePath.getParent();
                    int slash = baseName.lastIndexOf(47);
                    if (slash > 0) {
                        baseName = baseName.substring(0, slash);
                    }
                }
                if (!this.run(launcher, actualCmd, listener, modulePath, (OutputStream)new ForkOutputStream((OutputStream)baos, (OutputStream)listener.getLogger()))) {
                    return null;
                }
                Future task = modulePath.actAsync((FilePath.FileCallable)new StickyDateCleanUpTask(null));
                this.parseUpdateOutput(baseName + '/', baos, changedFileNames);
                this.join(task);
            }
        }
        return changedFileNames;
    }

    private void join(Future<Void> task) throws InterruptedException, IOException {
        try {
            task.get();
        }
        catch (ExecutionException e) {
            throw new IOException2((Throwable)e);
        }
    }

    private void parseUpdateOutput(String baseName, ByteArrayOutputStream output, List<String> result) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(output.toByteArray())));
        while ((line = in.readLine()) != null) {
            Matcher matcher = UPDATE_LINE.matcher(line);
            if (matcher.matches()) {
                result.add(baseName + matcher.group(1));
                continue;
            }
            matcher = REMOVAL_LINE.matcher(line);
            if (!matcher.matches()) continue;
            result.add(baseName + matcher.group(2));
        }
    }

    private String isUpdatable(FilePath dir) throws IOException, InterruptedException {
        return (String)dir.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkContents(File file, String contents) {
        try {
            BufferedReader r = new BufferedReader(new FileReader(file));
            try {
                String s = r.readLine();
                if (s == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.massageForCheckContents(s).equals(this.massageForCheckContents(contents));
                return bl;
            }
            finally {
                r.close();
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    private String massageForCheckContents(String s) {
        Matcher m = PSERVER_CVSROOT_WITH_PASSWORD.matcher(s = s.trim());
        if (m.matches()) {
            s = m.group(1) + m.group(2);
        }
        return s;
    }

    /*
     * Exception decompiling
     */
    private boolean calcChangeLog(AbstractBuild build, FilePath ws, List<String> changedFiles, File changelogFile, BuildListener listener) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        String cvspass;
        if (this.cvsRsh != null) {
            env.put("CVS_RSH", this.cvsRsh);
        }
        if (this.branch != null) {
            env.put("CVS_BRANCH", this.branch);
        }
        if ((cvspass = this.getDescriptor().getCvspassFile()).length() != 0) {
            env.put("CVS_PASSFILE", cvspass);
        }
    }

    protected final boolean run(Launcher launcher, ArgumentListBuilder cmd, TaskListener listener, FilePath dir, OutputStream out) throws IOException, InterruptedException {
        Map env = this.createEnvVarMap(true);
        int r = launcher.launch().cmds(cmd).envs(env).stdout(out).pwd(dir).join();
        if (r != 0) {
            listener.fatalError(this.getDescriptor().getDisplayName() + " failed. exit code=" + r);
        }
        return r == 0;
    }

    protected final boolean run(Launcher launcher, ArgumentListBuilder cmd, TaskListener listener, FilePath dir) throws IOException, InterruptedException {
        return this.run(launcher, cmd, listener, dir, (OutputStream)listener.getLogger());
    }

    protected final Map<String, String> createEnvVarMap(boolean overrideOnly) {
        HashMap<String, String> env = new HashMap<String, String>();
        if (!overrideOnly) {
            env.putAll(EnvVars.masterEnvVars);
        }
        this.buildEnvVars(null, env);
        return env;
    }

    static /* synthetic */ boolean access$000(CVSSCM x0) {
        return x0.flatten;
    }

    static /* synthetic */ void access$100(CVSSCM x0, File x1, String x2, ZipOutputStream x3, boolean x4) throws IOException {
        x0.archive(x1, x2, x3, x4);
    }

    static /* synthetic */ String access$300(CVSSCM x0) {
        return x0.cvsroot;
    }

    static /* synthetic */ boolean access$400(CVSSCM x0, File x1, String x2) {
        return x0.checkContents(x1, x2);
    }

    static /* synthetic */ String access$500(CVSSCM x0) {
        return x0.branch;
    }

    static /* synthetic */ boolean access$600(CVSSCM x0) {
        return x0.canUseUpdate;
    }

    static /* synthetic */ String access$700(CVSSCM x0) {
        return x0.cvsRsh;
    }

    static /* synthetic */ Logger access$800() {
        return LOGGER;
    }

    static /* synthetic */ CVSRepositoryBrowser access$902(CVSSCM x0, CVSRepositoryBrowser x1) {
        x0.repositoryBrowser = x1;
        return x0.repositoryBrowser;
    }

    static /* synthetic */ File access$1000(AbstractBuild x0) {
        return CVSSCM.getArchiveFile((AbstractBuild)x0);
    }
}

